import random
import numpy as np
import torch

def manual_seed(seed: int) -> None:
    random.seed(seed)
    np.random.seed(seed + 1)
    torch.manual_seed(seed + 2)
    torch.cuda.manual_seed(seed + 2)
    torch.backends.cudnn.deterministic = True
    torch.use_deterministic_algorithms = True