from typing import Iterable, Optional
import time

def mytqdm(iterable: Iterable, 
           message: Optional[str]="In Progress", 
           num_symbols: int = 50, 
           length: Optional[int]=None):
    print("", end="", flush=True)
    print(f"{message}... ", end="", flush=True)
    cnt = 0
    length = length or len(iterable)
    start = time.time()
    for i, item in enumerate(iterable):
        while i / length > cnt / num_symbols:
            print("#", end="", flush=True)
            cnt += 1
        yield item
    elapsed_time = time.time() - start
    elapsed_hour, elapsed_min, elapsed_sec = int(elapsed_time // 3600), int((elapsed_time // 60) % 60), int(elapsed_time % 60)
    print(f" Done. Time comsumed: {elapsed_hour}h {elapsed_min}m {elapsed_sec}s")