import numpy as np
from scipy.sparse import coo_matrix

# 读取文件中的数据
data = []
with open('C:\Users\guorh\Desktop\jksj21\MIP-main\data\MovieLens\test_seq.txt\test_seq.txt', 'r') as file:
    for line in file:
        row = list(map(int, line.strip().split()))
        data.append(row)

# 将数据转换为numpy数组
data = np.array(data)

# 获取行和列索引
rows, cols = data.shape
row_indices = np.repeat(np.arange(rows), cols)
col_indices = np.tile(np.arange(cols), rows)
data_flat = data.flatten()

# 创建COO格式矩阵
coo = coo_matrix((data_flat, (row_indices, col_indices)), shape=(rows, cols))

# 保存为新的文件
with open('C:\Users\guorh\Desktop\jksj21\MIP-main\data\MovieLens\test_seq.txt\test_seq.txt', 'w') as file:
    file.write("Row indices: {}\n".format(coo.row.tolist()))
    file.write("Column indices: {}\n".format(coo.col.tolist()))
    file.write("Data: {}\n".format(coo.data.tolist()))

print("COO格式矩阵已保存为test_coo.txt")
