from cassle.distillers.base import base_distill_wrapper
from cassle.distillers.contrastive import contrastive_distill_wrapper
from cassle.distillers.decorrelative import decorrelative_distill_wrapper
from cassle.distillers.knowledge import knowledge_distill_wrapper
from cassle.distillers.predictive import predictive_distill_wrapper
from cassle.distillers.dual_predictive1 import dual_predictive1_distill_wrapper
from cassle.distillers.predictive_mse import predictive_mse_distill_wrapper
from cassle.distillers.dual_moco5 import dual_moco5_wrapper
from cassle.distillers.dual_simclr5 import dual_simclr5_wrapper
from cassle.distillers.dual_barlow5_3 import dual_barlow5_3_wrapper


__all__ = [
    "base_distill_wrapper",
    "contrastive_distill_wrapper",
    "decorrelative_distill_wrapper",
    "nearest_neighbor_distill_wrapper",
    "dual_predictive1_distill_wrapper",
    "predictive_distill_wrapper",
    "predictive_mse_distill_wrapper",
    "dual_moco5_wrapper",
    "dual_simclr5_wrapper",
    "dual_barlow5_3_wrapper",
]

DISTILLERS = {
    "base": base_distill_wrapper,
    "contrastive": contrastive_distill_wrapper,
    "decorrelative": decorrelative_distill_wrapper,
    "knowledge": knowledge_distill_wrapper,
    "dual_predictive1": dual_predictive1_distill_wrapper,
    "predictive": predictive_distill_wrapper,
    "predictive_mse": predictive_mse_distill_wrapper,
    "dual_moco5": dual_moco5_wrapper,
    "dual_simclr5": dual_simclr5_wrapper,
    "dual_barlow5_3": dual_barlow5_3_wrapper,
}
