#!/bin/sh
set -e

# It requires two arguments: Model type and experiment name.
if [[ $# -eq 2 ]] ; then
    exp=$2
else
    echo 'Experiment name is missing!'
    exit 1
fi

# ImageNet data
export IMAGENET_DIR=$1

# Create folder.
export OUTPUT_DIR=output/$exp

if [ ! -d "${OUTPUT_DIR}" ]; then
  echo "Folder $output does not exist. Create folder and copy files ..."
  mkdir -p ${OUTPUT_DIR}
  cp $0 ${OUTPUT_DIR}/run.bash

  python -m torch.distributed.launch \
    --nproc_per_node=8 --use_env main_pretrain_rc_v1b.py \
    --model rc_vit_base_patch16 \
    --batch_size 256 \
    --accum_iter 2 \
    --epochs 800 \
    --warmup_epochs 40 \
    --norm_pix_loss \
    --mask_ratio 0.75 \
    --blr 1.5e-4 \
    --weight_decay 0.05 \
    --data_path ${IMAGENET_DIR} \
    --log_dir ${OUTPUT_DIR} \
    --output_dir ${OUTPUT_DIR} | tee -a ${OUTPUT_DIR}/history.txt

else
    echo "Folder ${OUTPUT_DIR} already exists. Please remove the folder and re-run the script."
fi

OMP_NUM_THREADS=1 python -m torch.distributed.launch --nproc_per_node=8 main_finetune_rc.py \
    --batch_size 128 \
    --model vit_base_patch16 \
    --finetune ${OUTPUT_DIR}/checkpoint-799.pth \
    --epochs 100 \
    --blr 5e-4 --layer_decay 0.65 \
    --weight_decay 0.05 --drop_path 0.1 --reprob 0.25 --mixup 0.8 --cutmix 1.0 \
    --checkpoint_key teacher \
    --dist_eval --data_path ${IMAGENET_DIR} \
    --log_dir ${OUTPUT_DIR}/finetune_teacher \
    --output_dir ${OUTPUT_DIR}/finetune_teacher | tee -a ${OUTPUT_DIR}/finetune_teacher/history.txt
