# Calculate average values and standard deviations for each data point
avg_rewards = []
avg_costs = []
std_rewards = []
std_costs = []
for r, c in zip(rewards, costs):
    avg_rewards.append(sum(r) / len(r))
    avg_costs.append(sum(c) / len(c))
    std_rewards.append(np.std(r))
    std_costs.append(np.std(c))

# Read data from the second folder
third_rewards = []
third_costs = []
for filename in os.listdir(folder2_path):
    if filename.endswith('.csv'):
        file_path = os.path.join(folder2_path, filename)
        with open(file_path, 'r') as f:
            data_points = []
            for line in f:
                values = line.strip().split(',')
                if values[0] == 'Reward':
                    data_point = [float(values[1]), None]
                elif values[0] == 'Cost':
                    data_point[1] = float(values[1])
                    data_points.append(data_point)
            if data_points:
                num_data_points = len(data_points)
                for i in range(num_data_points):
                    if i >= len(third_rewards):
                        third_rewards.append([data_points[i][0]])
                        third_costs.append([data_points[i][1]])
                    else:
                        third_rewards[i].append(data_points[i][0])
                        third_costs[i].append(data_points[i][1])

# Calculate average values and standard deviations for each data point
avg_third_rewards = []
avg_third_costs = []
std_third_rewards = []
std_third_costs = []
for r, c in zip(third_rewards, third_costs):
    avg_third_rewards.append(sum(r) / len(r))
    avg_third_costs.append(sum(c) / len(c))
    std_third_rewards.append(np.std(r))
    std_third_costs.append(np.std(c))

# Save data to CSV file
with open(csv_file, 'w', newline='') as csvfile:
    writer = csv.writer(csvfile)
    writer.writerow(['Cost Mean', 'Cost Std', 'PCPO Reward Mean', 'PCPO Reward Std', 'Flipping-based Reward Mean', 'Flipping-based Reward Std', 'Flipped Reward Std', 'Flipped Cost Std', 'Flipping-based Cost Mean'])
    for cost_mean, cost_std, r1_mean, r1_std, r2_mean, r2_std, flipped_r_std, flipped_c_std, flipped_c_mean in zip(avg_costs, std_costs, avg_rewards, std_rewards, avg_third_rewards, std_third_rewards, std_third_rewards, std_third_costs, avg_third_costs):
        writer.writerow([cost_mean, cost_std, r1_mean, r1_std, r2_mean, r2_std, flipped_r_std, flipped_c_std, flipped_c_mean])