import matplotlib.pyplot as plt

def plot_results(results_file_path, results2_file_path):
    # Read data from the first file
    rewards = []
    costs = []
    with open(results_file_path, 'r') as f:
        for line in f:
            values = line.strip().split(',')
            if values[0] == 'Reward':
                rewards.append(float(values[1]))
            elif values[0] == 'Cost':
                costs.append(float(values[1]))

    # Read data from the second file
    optimal_values = []
    cost_limits = []
    with open(results2_file_path, 'r') as f:
        next(f)  # Skip the header line
        for line in f:
            values = line.strip().split(',')
            cost_limits.append(float(values[0]))
            optimal_values.append(float(values[1]))

    # Plot the data
    plt.figure(figsize=(10, 6))
    plt.plot(costs, rewards, 'ro-', label='Reward vs Cost')
    plt.plot(cost_limits, optimal_values, 'b^-', label='Optimal Value vs Cost Limit')
    plt.xlabel('Cost / Cost Limit')
    plt.ylabel('Reward / Optimal Value')
    plt.title('Results Comparison')
    plt.legend()
    plt.show()

if __name__ == '__main__':
    results1_path = r"[FILE_PATH]"
    results2_path = r"[FILE_PATH]"
    plot_results(results1_path, results2_path)