import os
import csv
import re
import matplotlib.pyplot as plt

# Specify directory path, T value, and output file path
base_path = 'directory_path'  # Replace with the actual directory path
T = 30  # Specify the value of T
output_path = 'output_directory_path'  # Replace with the desired output directory path

# Get all seed folders
seed_folders = [f for f in os.listdir(base_path) if f.startswith('seed')]

# Get the file names from the first seed folder as a reference
file_names = [f for f in os.listdir(os.path.join(base_path, seed_folders[0])) if f.endswith('.csv')]

# Sort the file names based on the numeric part
file_names.sort(key=lambda x: int(re.findall(r'\d+', x)[0]))

# Dictionary to store the results
results = {}

# Iterate over each file name
for file_name in file_names:
   probabilities = []

   # Iterate over each seed folder
   for seed_folder in seed_folders:
       file_path = os.path.join(base_path, seed_folder, file_name)

       # Read the file and extract the probability for the corresponding T value
       with open(file_path, 'r') as file:
           csv_reader = csv.reader(file)
           next(csv_reader)  # Skip header

           for row in csv_reader:
               if int(row[0]) == T:
                   probabilities.append(float(row[1]))
                   break

   # Calculate the average and store the result
   avg_probability = sum(probabilities) / len(probabilities)
   results[file_name] = avg_probability

# Plot the chart
plt.figure(figsize=(10, 6))
plt.bar(range(len(results)), results.values())
plt.xlabel('File Name')
plt.ylabel('Average Probability')
plt.title(f'Average Probability for T={T}')
plt.xticks(range(len(results)), results.keys(), rotation=45)
plt.tight_layout()
plt.show()

# Save the results to a CSV file in the specified output path
output_file = os.path.join(output_path, 'output_file.csv')
os.makedirs(output_path, exist_ok=True)  # Create the output directory if it doesn't exist

with open(output_file, 'w', newline='') as file:
   csv_writer = csv.writer(file)
   csv_writer.writerow(['File Name', 'Average Probability'])

   for file_name, avg_probability in results.items():
       csv_writer.writerow([file_name, avg_probability])

print(f"Results saved to {output_file}")