import pandas as pd
import os

# Load progress.csv file
progress_file_path = r"[FILE_PATH]"  # Replace with actual file path
progress_df = pd.read_csv(progress_file_path)

# Calculate mean of first and second columns
average_first_col = progress_df.iloc[:, 0].mean()
average_second_col = progress_df.iloc[:, 1].mean()

# Create new DataFrame to store results
result_data = {'Metric': ['Reward', 'Cost'], 'Average': [average_first_col, average_second_col]}
result_df = pd.DataFrame(result_data)

# Specify results file path
results_file_path = r"[FILE_PATH]"  # Replace with actual file path

# Check if file exists and write in append mode or create new file
if os.path.exists(results_file_path):
    result_df.to_csv(results_file_path, mode='a', header=False, index=False)
else:
    result_df.to_csv(results_file_path, index=False)

print(f"Average data successfully saved to {results_file_path}")