import pandas as pd
from scipy.optimize import linprog
import io

# DataFrame
document_content = """

"""

#  DataFrame
results_df = pd.read_csv(io.StringIO(document_content), header=None, names=['Metric', 'Value'])

# get Cost and Reward 
cost_reward_pairs = []
for i in range(0, len(results_df), 2):
    reward_value = results_df.iloc[i]['Value']
    cost_value = results_df.iloc[i+1]['Value']
    cost_reward_pairs.append([float(cost_value), float(reward_value)])

# transform to DataFrame 
cleaned_df = pd.DataFrame(cost_reward_pairs, columns=['Cost', 'Reward'])

# set goal
reward_values = cleaned_df['Reward'].values
cost_values = cleaned_df['Cost'].values
num_items = len(cost_values)

# save
optimized_results = []

# optimal problem
for cost_limit in cost_values:
    # function set: max:w_i * r_i 
    c = -reward_values  
    
    # constraints
    A_ub = [cost_values]  # all w_i * c_i  <= C
    b_ub = [cost_limit]
    A_eq = [[1] * num_items]  # all w_i  = 1
    b_eq = [1]
    
    # count
    result = linprog(c, A_ub=A_ub, b_ub=b_ub, A_eq=A_eq, b_eq=b_eq, bounds=(0, None), method='highs')
    
    # save
    optimized_results.append({
        'Cost_Limit': cost_limit,
        'Optimal_Value': -result.fun if result.success else None,
        'Optimal_Weights': result.x.tolist() if result.success else None
    })

# save
optimized_df = pd.DataFrame(optimized_results)
optimized_results_path = r"path"
optimized_df.to_csv(optimized_results_path, index=False)
print(f"save to  {optimized_results_path}")