clear
clc

% Define the parameters for obstacles
px_obs_1 = 7.5;
py_obs_1 = 10;
r_obs_1 = 2.5;

px_obs_2 = 10;
py_obs_2 = 5;
r_obs_2 = 2.5;

% Define the parameters for goal 
pxg = 15; 
pyg = 15;
rg_s = 2;
rg = 1.5;

% Define the parameters for ellipsoid (CBF for side)
len_a = 5; len_b = 3;
xc_elp = 8.5; yc_elp = 7.5;
phi = -pi/3;

% Define the sampling time and Entire Time horizon
dt = 0.2;
T = 8; % Entire Horizon
Time = 0:dt:T;
N = length(Time); % Entire Horizon Steps

% Define the limitations for actions
dx_max = 3; dx_min = -3;
dy_max = 3; dy_min = -3;

% Define the initial state
px_ini = 0;
py_ini = 0;

% Parameter for Noise
delta = 0.6;
dxn_max = delta;
dyn_max = delta;

ratio_all = 1:0.05:2.2; % beta in the paper
n_ratio = length(ratio_all);
s_all_ratio = cell(n_ratio,1);
a_all_ratio = cell(n_ratio,1);

for i_ratio=1:n_ratio

% Setting for MPC
n_mpc = 16; % Horizon in MPC 
n_sam = 80;
ratio = ratio_all(i_ratio); 

% Setting the big Matrix
A = [1 0;0 1;]; B = [dt*N/n_mpc 0;0 dt*N/n_mpc;];
[A_big,B_big] = Matrix(n_mpc,A,B);

% Number of trajectories 
n_tr = 1;

s_all = cell(n_tr,1);
a_all = cell(n_tr,1);
for i_tr=1:n_tr
    s_all_itr = zeros(2,N);
    s_all_itr(:,1) = [px_ini;py_ini;];
    a_all_itr = zeros(2,N-1);
    for i=2:N
        i_ratio
        i_tr
        i
        s_ini = s_all_itr(:,i-1);
        s_ini_matrix = [];
        for ip=1:n_sam
            s_ini_matrix = [s_ini_matrix,s_ini];
        end
        %z0 = zeros(1,n_mpc*2);
        z0 = randn(1,n_mpc*2);
        ub = [dx_max+zeros(1,n_mpc),dy_max+zeros(1,n_mpc);];
        lb = [dx_min+zeros(1,n_mpc),dy_min+zeros(1,n_mpc);];
        dxn_i_all = randn(n_sam,n_mpc)*dxn_max; 
        dyn_i_all = randn(n_sam,n_mpc)*dyn_max;

        fun = @(z)Cost_CC(z,s_ini_matrix,pxg,pyg,dxn_i_all,dyn_i_all,A_big,B_big,n_mpc);
        if ratio<=1.5
            nonlcon = @(z)Constraint_CC_matrix(z,s_ini,n_mpc,px_obs_1,py_obs_1,r_obs_1,px_obs_2,py_obs_2,r_obs_2,pxg,pyg,rg,dxn_max,A_big,B_big,ratio,N,dt);
        else
            nonlcon = @(z)Constraint_CC_matrix_side(z,s_ini,n_mpc,len_a,len_b,xc_elp,yc_elp,phi,dxn_max,A_big,B_big,ratio,N,dt);
        end
        options = optimoptions('fmincon','Algorithm','sqp');
        tic
        [z_opt, fval] = fmincon(fun, z0, [], [], [], [], lb, ub, nonlcon, options);
        toc
        
        dxn_i = randn(1,1)*dxn_max;
        dyn_i = randn(1,1)*dyn_max;
        ap_i = [z_opt(1)+dxn_i;z_opt(n_mpc+1)+dyn_i;];
        s_all_itr(:,i) = system_model(s_ini,ap_i,dt);
        a_all_itr(:,i-1) = [z_opt(1);z_opt(n_mpc+1);];
    end
    
    s_all{i_tr} = s_all_itr;
    a_all{i_tr} = a_all_itr;
end

s_all_ratio{i_ratio} = s_all;
a_all_ratio{i_ratio} = a_all;
end

save data_train_entire_try s_all_ratio a_all_ratio ratio_all;