clear
clc

load data_test;

theta = 0:pi/50:2*pi;
% Define the parameters for obstacles
px_obs_1 = 7.5;
py_obs_1 = 10;
r_obs_1 = 2.5;

px_obs_2 = 10;
py_obs_2 = 5;
r_obs_2 = 2.5;

% Define the parameters for goal 
pxg = 15; 
pyg = 15;
rg_s = 2;
rg = 1.5;


xCoord_g = pxg + rg_s*cos(theta);
yCoord_g = pyg + rg_s*sin(theta);

xCoord_obs_1 = px_obs_1 + r_obs_1*cos(theta);
yCoord_obs_1 = py_obs_1 + r_obs_1*sin(theta);

xCoord_obs_2 = px_obs_2 + r_obs_2*cos(theta);
yCoord_obs_2 = py_obs_2 + r_obs_2*sin(theta);

n_ratio = length(s_all_ratio);
cost_mean_ratio = zeros(n_ratio,1);
distance_mean_ratio = zeros(n_ratio,1);
prob_vio_ratio = zeros(n_ratio,1);

for i_ratio=1:n_ratio
    s_all = s_all_ratio{i_ratio};
    n_tr = length(s_all);
    cost_tr = zeros(n_tr,1);
    collision_tr = zeros(n_tr,1);
    distance_tr = zeros(n_tr,1);
    for i_tr=1:n_tr
        px_itr = s_all{i_tr}(1,:);
        py_itr = s_all{i_tr}(2,:);
        cost_tr(i_tr) = sum( 1./((px_itr-pxg).^2 + (py_itr-pyg).^2+0.1) )/length(px_itr);
        distance_tr(i_tr) = sum( (px_itr(2:end)-px_itr(1:end-1)).^2 + (py_itr(2:end)-py_itr(1:end-1)).^2 );
        distance_1 = r_obs_1^2 - (px_itr' - px_obs_1).^2 - (py_itr' - py_obs_1).^2;
        distance_2 = r_obs_2^2 - (px_itr' - px_obs_2).^2 - (py_itr' - py_obs_2).^2;
        g = max([distance_1;distance_2;]);
        if g>0
            collision_tr(i_tr) = 1;
        end
    end
    cost_mean_ratio(i_ratio) = mean(cost_tr);
    distance_mean_ratio(i_ratio) = mean(distance_tr);
    prob_vio_ratio(i_ratio) = mean(collision_tr);
end


figure(1)
plot(prob_vio_ratio,cost_mean_ratio,'vk','LineWidth',2)
xlabel('$\alpha$','Interpreter','Latex')
ylabel("$J^*_{\alpha}$",'Interpreter','Latex')
set(gca,'FontSize',16,'fontname','Times New Roman')
grid on