import numpy as np
import os


data = np.load(r"path", allow_pickle=True)

T_values = list(range(3, 31))


csv_path = os.path.join(os.path.expanduser("~"), r"path", ".csv")
csv_path_all = os.path.join(os.path.expanduser("~"), r"path", ".csv")

with open(csv_path, 'w') as f, open(csv_path_all, 'w') as f_all:

    f.write("T,Average_Probability\n")
    f_all.write("T,Trajectory_Index,Probability\n")

    for T in T_values:
        a = np.zeros(data.shape[0])
        b = np.zeros(data.shape[0])

        for i in range(data.shape[0]):
            trajectory = data[i]
            for j in range(len(trajectory) - T + 1):
                segment = trajectory[j:j+T]
                a[i] += 1
                if np.all(segment == 0):
                    b[i] += 1

        c = 1 - (b / a)
        avg_c = np.mean(c)


        f.write(f"{T},{avg_c}\n")

        
        for i in range(data.shape[0]):
            f_all.write(f"{T},{i},{c[i]}\n")

print("Average results saved to", csv_path)
print("All results saved to", csv_path_all)