import csv
import matplotlib.pyplot as plt

# Read data from the first file (cpo_data.csv)
rewards = []
with open('file_path_1.csv', 'r') as file:
   csv_reader = csv.reader(file)
   next(csv_reader)  # Skip header
   for row in csv_reader:
       rewards.append(float(row[2]))  # Assuming reward is in the third column (index 2)

# Read data from the second file (probability_data.csv)
probabilities = []
with open('file_path_2.csv', 'r') as file:
   csv_reader = csv.reader(file)
   next(csv_reader)  # Skip header
   for row in csv_reader:
       probabilities.append(float(row[1]))  # Assuming probability is in the second column (index 1)

# Plot the chart
plt.figure(figsize=(10, 6))
plt.plot(probabilities, rewards, marker='o')
plt.xlabel('Probability')
plt.ylabel('Reward')
plt.title('Reward vs. Probability')
plt.grid(True)
plt.tight_layout()

# Save the plot to a file
output_file = 'output_file_path.png'
plt.savefig(output_file)
print(f"Plot saved to {output_file}")

# Show the plot
plt.show()