function [c,ceq] = Constraint_CC_matrix_side(z,s_ini,n_mpc,len_a,len_b,xc_elp,yc_elp,phi,dxn_max,A_big,B_big,ratio,N,dt)

ceq = [];

ap_all = [z(1:n_mpc);z(n_mpc+1:end);];
ap_all_reform = [ap_all(1,:)';ap_all(2,:)';];
ap_all_reform(1:2:end-1) = ap_all(1,:)';
ap_all_reform(2:2:end) = ap_all(2,:)';

s_pred_tr = A_big*s_ini + B_big*ap_all_reform;

%%%%%%%%%%%%%%%%%%%%%
s_pred_tr_1 = [0;s_pred_tr(1:2:end-1,:);]; % Center point of circle x axis
s_pred_tr_2 = [0;s_pred_tr(2:2:end,:);];  % Center point of circel y axis

r_noise = 0:1:n_mpc; r_noise = r_noise';
r_noise = sqrt(r_noise)*dxn_max*dt*N/n_mpc;

%%%%%%%%%%%%%%%%%% 
% Transform the circle center according to the rotation of the ellipsoid
s_pred_tr_1_prime = (s_pred_tr_1 - xc_elp) * cos(phi) + (s_pred_tr_2 - yc_elp) * sin(phi);
s_pred_tr_2_prime = - (s_pred_tr_1 - xc_elp) * sin(phi) + (s_pred_tr_2 - yc_elp) * cos(phi);

% Calculate the distance from the transformed circle center to the ellipsoid center
D_centers_prime = sqrt(s_pred_tr_1_prime.^2+s_pred_tr_2_prime.^2);

% Calculate the minimum radius of the ellipsoid along the line through the transformed circle center
C = s_pred_tr_1_prime.^2 + s_pred_tr_2_prime.^2;
A = s_pred_tr_1_prime.^2 * (len_a^2);
B = s_pred_tr_2_prime.^2 * (len_b^2);

r_ellipse_prime = sqrt( A ./ C + B ./ C);

distance_1_all = r_ellipse_prime - D_centers_prime + r_noise*ratio;

c = distance_1_all;





