clear
clc

load data_train_entire;

n_ratio = length(s_all_ratio);
n_tr = length(s_all_ratio{1});

for i_ratio=1:n_ratio

s_all_input = [];
a_all_output = [];

for i_tr=1:n_tr
    s_all_input = [s_all_input,s_all_ratio{i_ratio}{i_tr}(:,1:end-1);];
    a_all_output = [a_all_output,a_all_ratio{i_ratio}{i_tr};];
end

% Create a feedforward network with 10 neurons in one hidden layer
hiddenLayerSize = 20;
net = fitnet(hiddenLayerSize);

% Set up division of data for training, validation, testing
net.divideParam.trainRatio = 70/100;
net.divideParam.valRatio = 15/100;
net.divideParam.testRatio = 15/100;

% Train the network
[net, tr] = train(net, s_all_input, a_all_output);
% Save the trained network
filename = sprintf('trainedNetwork_%02d.mat', i_ratio);
save(filename, 'net');

% Test the network
outputs = net(s_all_input);
errors = gsubtract(a_all_output, outputs);
performance = perform(net, a_all_output, outputs);

% Visualization
figure, plotperform(tr);
figure, plotregression(a_all_output, outputs);

end