clear
clc

load data_for_cal_flip_prob.mat;

n_ratio = length(cost_mean_ratio);
w_ratio = zeros(n_ratio,n_ratio);
cost_flip_ratio = zeros(n_ratio,1);

lb = zeros(n_ratio,1);
ub = zeros(n_ratio,1) + 1;
A = prob_vio_ratio';
Aeq = zeros(1,n_ratio) + 1;
beq = 1;
x0 = zeros(n_ratio,1)+1/n_ratio;

for i_ratio=1:n_ratio
    c = cost_mean_ratio;
    b = prob_vio_ratio(i_ratio);
    options = optimoptions('linprog','Algorithm','dual-simplex','Display','iter');
    [xopt, fval, exitflag, output] = linprog(c, A, b, Aeq, beq, lb, ub, options);
    cost_flip_ratio(i_ratio) = fval;
    w_ratio(:,i_ratio) = xopt;
end

plot(prob_vio_ratio,cost_mean_ratio,'vk','LineWidth',2)
hold on
plot(prob_vio_ratio,cost_flip_ratio,'ob','LineWidth',2)
xlabel('$\alpha$','Interpreter','Latex')
ylabel("$J^*_{\alpha}$",'Interpreter','Latex')
set(gca,'FontSize',16,'fontname','Times New Roman')
%xlim([0,20])
%ylim([0,20])
grid on

% save flip_para w_ratio prob_vio_ratio cost_mean_ratio;



