## Colored-MNIST 

The code provided here runs empirical risk minimization (ERM), invariant risk minimization (IRM), and deceptive risk minimization (DRM) on the Colored-MNIST example introduced by Arjovsky et al. (2019). 

This code builds on the following repositories:
* [https://github.com/facebookresearch/InvariantRiskMinimization](https://github.com/facebookresearch/InvariantRiskMinimization)
* [https://github.com/reiinakano/invariant-risk-minimization](https://github.com/reiinakano/invariant-risk-minimization)

To install the conda environment and python packages, run the following:
```
conda create -n drm-colored-mnist pip python==3.8.18
conda activate drm-colored-mnist
pip install -r requirements.txt
pip install torchsort==0.1.9
```

The following script will run ERM and DRM with 10 seeds on Colored-MNIST:
```
python generate_results.py
```

This will run IRM:
```
python irm.py
```

For plotting training and test success rates across different seeds, run:
```
plot_results.ipynb
```

If you want to re-create the t-SNE visualization from the paper, run:
```
plot_tsne.ipynb
```