This code packages are for reviewers’ checking only. Please do not distribute to others. We will release the codes and results after the review.
We test our methods with the tasks developed by previous researchers, which are all open to use for common research. Our research is consistent with their intended use. This code base is built upon https://github.com/BorealisAI/llm-pddl-planning.

## Setup Environment
1. Install the python requirements via 
```bash
conda create -n vlmfp python=3.9
conda activate vlmfp
pip install -r requirements.txt
```

2. Download the following external libraries:

* [VAL](https://github.com/KCL-Planning/VAL)
* [Fast Downward 22.06.1](https://github.com/aibasel/downward/releases/tag/release-22.06.1)
* [LlamaFactory] (https://github.com/hiyouga/LLaMA-Factory)

3. Configure the following environment variables in `reproduce.sh`: `FD_PY_PATH` (path to the .py file of fast downard), `VAL_BIN_PATH` (path to the VAL library binary file), `OPENAI_API_KEY` (OpenAI key), `WANDB_ENTITY` (wandb entity), `WANDB_PROJECT` (wandb project).

4. Run 
```
bash reproduce.sh
```
to run the experiments.

However, due to the space limit, we cannot upload our collected datasets and fine-tuned model.
Other parts of the codebase showcase how we build the VLMFP framework. In data_my folder, there are the testing problem instances we use for testing. We include a small sample dataset for frozenlake `frozenlake_size_4.json` as a reference for how our collected dataset looks like.
Upon acceptance, we will release our code, model, and dataset publicly under an open-source license.