(define (domain maze)
    (:requirements :strips)
    (:predicates 
        (move-dir-up ?v0 ?v1)
        (move-dir-down ?v0 ?v1)
        (move-dir-left ?v0 ?v1)
        (move-dir-right ?v0 ?v1)
        (at ?v0)
        (is-goal ?v0)
    )

    (:action move-up
            :parameters (?from ?to)
            :precondition (and (at ?from)
                    (move-dir-up ?from ?to))
            :effect (and
                    (not (at ?from))
                    (at ?to))
    )

    (:action move-down
            :parameters (?from ?to)
            :precondition (and (at ?from)
                    (move-dir-down ?from ?to))
            :effect (and
                    (not (at ?from))
                    (at ?to))
    )

    (:action move-left
            :parameters (?from ?to)
            :precondition (and (at ?from)
                    (move-dir-left ?from ?to))
            :effect (and
                    (not (at ?from))
                    (at ?to))
    )


    (:action move-right
            :parameters (?from ?to)
            :precondition (and (at ?from)
                    (move-dir-right ?from ?to))
            :effect (and
                    (not (at ?from))
                    (not (clear ?to))
                    (at ?to))
    )

)
