(define (domain package)
  (:requirements :strips :typing)
  
  (:types
    position  package  direction
  )
  
  (:predicates
    (at ?pos - position)              ; agent is at position
    (package-at ?pkg - package ?pos - position) ; package is at position
    (package-open ?pkg - package)     ; package is open
    (package-closed ?pkg - package)   ; package is closed
    (facing ?dir - direction)         ; agent is facing direction
    (left-turn ?from - direction ?to - direction)
    (right-turn ?from - direction ?to - direction)
    (move-dir ?pos1 - position ?pos2 - position ?dir - direction) ; positions are move-dir in direction
  )
  
  (:action turn-left
    :parameters (?current-dir - direction ?new-dir - direction)
    :precondition (and 
      (facing ?current-dir)
      (left-turn ?current-dir ?new-dir)
    )
    :effect (and 
      (not (facing ?current-dir))
      (facing ?new-dir)
    )
  )
  
  (:action turn-right
    :parameters (?current-dir - direction ?new-dir - direction)
    :precondition (and 
      (facing ?current-dir)
      (right-turn ?current-dir ?new-dir)
    )
    :effect (and 
      (not (facing ?current-dir))
      (facing ?new-dir)
    )
  )
  
  (:action move
    :parameters (?from - position ?to - position ?dir - direction)
    :precondition (and
      (at ?from)
      (facing ?dir)
      (move-dir ?from ?to ?dir)
    )
    :effect (and
      (not (at ?from))
      (at ?to)
    )
  )
  
  (:action open
    :parameters (?pkg - package ?pos - position ?pkgpos - position ?dir - direction)
    :precondition (and
      (at ?pos)
      (package-at ?pkg ?pkgpos)
      (package-closed ?pkg)
      (facing ?dir)
      (move-dir ?pos ?pkgpos ?dir)
    )
    :effect (and
      (not (package-closed ?pkg))
      (package-open ?pkg)
    )
  )
  
  (:action close
    :parameters (?pkg - package ?pos - position ?pkgpos - position ?dir - direction)
    :precondition (and
      (at ?pos)
      (package-at ?pkg ?pkgpos)
      (package-open ?pkg)
      (facing ?dir)
      (move-dir ?pos ?pkgpos ?dir)
    )
    :effect (and
      (not (package-open ?pkg))
      (package-closed ?pkg)
    )
  )
)