Example Scenario: 

From the image we can observe that: 
Initially:
- The size of the gridworld is 4x4
- The agent is at pos-4-4.
- The agent's orientation is up.
- The printer is at pos-4-1.
- The positions pos-1-1, pos-1-2, pos-1-3, pos-2-1, pos-2-2, pos-2-3 are the desk region.

Your goal is to achieve the following configuration:
- The printer is dropped on the desk and is toggled on.

Example Plan:
```pddl
; Stage 1. **Adjust the orientation:**
; the agent's original orientation is facing up, after turn-left, now facing left 
(turn-left up left)

; Stage 2. **Move to the Printer:**
; the agent's original position is pos-4-4, after move left, now at pos-4-3 
(move pos-4-4 pos-4-3 left)

; the agent's original position is pos-4-3, after move left, now at pos-4-2 
(move pos-4-3 pos-4-2 left)

; Stage 3. **Pick up the Printer:**
; the agent's standing at pos-4-2, now it can only pick up objects at adjacent cells
; since the printer is at pos-4-1, which is adjacent to pos-4-2 at left, the agent pick-up the object at pos-4-1
(pick-up pos-4-2 pos-4-1 left)

; Stage 4. **Adjust the orientation:**
; the agent's original orientation is facing left, after turn-right, now facing up 
(turn-right left up)

; Stage 5. **Move to the Desk:**
; the agent's original position is pos-4-2, after move up, now at pos-3-2
(move pos-4-2 pos-3-2 up)

; Stage 6. **Drop down the Printer:**
; the agent's standing at pos-3-2, now it can only drop down objects at adjacent cells
; since it is trying to drop the printer at pos-2-2, which is adjacent to pos-3-2 at left. So the agent drop-down the object at pos-2-2 on desk
(drop-down-desk pos-3-2 pos-2-2 up)

; Stage 7. **Toggle on the Printer:**
; the agent's standing at pos-3-2, now it can only toggle on objects at adjacent cells
; since the printer is at pos-2-2, which is adjacent to pos-3-2 at left, the agent toggle-on the object at pos-2-2
(toggle-on pos-3-2 pos-2-2 up)
```
