(define (domain maze)
    (:requirements :strips)
    (:predicates 
        (move-dir-up ?v0 ?v1)
        (move-dir-down ?v0 ?v1)
        (move-dir-left ?v0 ?v1)
        (move-dir-right ?v0 ?v1)
        (clear ?v0)
        (at ?v0)
        (is-goal ?v0)
    )

    (:action move-up
            :parameters (?from ?to)
            :precondition (and (at player-1 ?from)
                    (clear ?to)
                    (move-dir-up ?from ?to))
            :effect (and
                    (not (at player-1 ?from))
                    (not (clear ?to))
                    (at player-1 ?to)
                    (clear ?from))
    )

    (:action move-down
            :parameters (?from ?to)
            :precondition (and (at player-1 ?from)
                    (clear ?to)
                    (move-dir-down ?from ?to))
            :effect (and
                    (not (at player-1 ?from))
                    (not (clear ?to))
                    (at player-1 ?to)
                    (clear ?from))
    )

    (:action move-left
            :parameters (?from ?to)
            :precondition (and (at player-1 ?from)
                    (clear ?to)
                    (move-dir-left ?from ?to))
            :effect (and
                    (not (at player-1 ?from))
                    (not (clear ?to))
                    (at player-1 ?to)
                    (clear ?from))
    )


    (:action move-right
            :parameters (?from ?to)
            :precondition (and (at player-1 ?from)
                    (clear ?to)
                    (move-dir-right ?from ?to))
            :effect (and
                    (not (at player-1 ?from))
                    (not (clear ?to))
                    (at player-1 ?to)
                    (clear ?from))
    )

)
