(define (problem printer-problem-0)
  (:domain printer)
  
  (:objects
    ; Positions in 4x4 grid
    pos-1-1 pos-1-2 pos-1-3 pos-1-4 pos-2-1 pos-2-2 pos-2-3 pos-2-4 pos-3-1 pos-3-2 pos-3-3 pos-3-4 pos-4-1 pos-4-2 pos-4-3 pos-4-4 - position
    
    ; Directions
    up down left right - direction
    
    ; Printer
    the-printer - printer
  )
  
  (:init
    ; Agent initial position and orientation
    (at pos-1-4)
    (facing down)
    
    ; Printer initial position
    (printer-at pos-1-3)
    
    ; Desk region
    (desk-region pos-2-1)
    (desk-region pos-2-2)
    (desk-region pos-2-3)
    (desk-region pos-3-1)
    (desk-region pos-3-2)
    (desk-region pos-3-3)
    
    ; Turn relations
    (left-turn up left)
    (left-turn left down)
    (left-turn down right)
    (left-turn right up)
    
    (right-turn up right)
    (right-turn right down)
    (right-turn down left)
    (right-turn left up)
    
    ; Grid adjacency relationships
    (move-dir pos-1-1 pos-1-2 right) (move-dir pos-1-2 pos-1-1 left)
    (move-dir pos-1-2 pos-1-3 right) (move-dir pos-1-3 pos-1-2 left)
    (move-dir pos-1-3 pos-1-4 right) (move-dir pos-1-4 pos-1-3 left)
    (move-dir pos-2-1 pos-2-2 right) (move-dir pos-2-2 pos-2-1 left)
    (move-dir pos-2-2 pos-2-3 right) (move-dir pos-2-3 pos-2-2 left)
    (move-dir pos-2-3 pos-2-4 right) (move-dir pos-2-4 pos-2-3 left)
    (move-dir pos-3-1 pos-3-2 right) (move-dir pos-3-2 pos-3-1 left)
    (move-dir pos-3-2 pos-3-3 right) (move-dir pos-3-3 pos-3-2 left)
    (move-dir pos-3-3 pos-3-4 right) (move-dir pos-3-4 pos-3-3 left)
    (move-dir pos-4-1 pos-4-2 right) (move-dir pos-4-2 pos-4-1 left)
    (move-dir pos-4-2 pos-4-3 right) (move-dir pos-4-3 pos-4-2 left)
    (move-dir pos-4-3 pos-4-4 right) (move-dir pos-4-4 pos-4-3 left)
    (move-dir pos-1-1 pos-2-1 down) (move-dir pos-2-1 pos-1-1 up)
    (move-dir pos-1-2 pos-2-2 down) (move-dir pos-2-2 pos-1-2 up)
    (move-dir pos-1-3 pos-2-3 down) (move-dir pos-2-3 pos-1-3 up)
    (move-dir pos-1-4 pos-2-4 down) (move-dir pos-2-4 pos-1-4 up)
    (move-dir pos-2-1 pos-3-1 down) (move-dir pos-3-1 pos-2-1 up)
    (move-dir pos-2-2 pos-3-2 down) (move-dir pos-3-2 pos-2-2 up)
    (move-dir pos-2-3 pos-3-3 down) (move-dir pos-3-3 pos-2-3 up)
    (move-dir pos-2-4 pos-3-4 down) (move-dir pos-3-4 pos-2-4 up)
    (move-dir pos-3-1 pos-4-1 down) (move-dir pos-4-1 pos-3-1 up)
    (move-dir pos-3-2 pos-4-2 down) (move-dir pos-4-2 pos-3-2 up)
    (move-dir pos-3-3 pos-4-3 down) (move-dir pos-4-3 pos-3-3 up)
    (move-dir pos-3-4 pos-4-4 down) (move-dir pos-4-4 pos-3-4 up)
  )
  
  (:goal
    (and
      (printer-dropped-on-desk)
      (printer-on)
    )
  )
)