(define (domain overcooked)
  (:requirements :strips :typing)
  
  (:types
    position
    player
    ingredient
    plate
    counter
    chopping-board
    delivery-point
    direction
  )
  
  (:predicates
    ;; Position relations
    (move-dir ?p1 ?p2 - position ?dir - direction)  ; p2 is in direction dir from p1
    (at-player ?player - player ?pos - position)  ; player location
    (at-ingredient ?ingredient - ingredient ?pos - position)  ; ingredient location
    (at-plate ?plate - plate ?pos - position)  ; plate location
    (at-chopping-board ?board - chopping-board ?pos - position)  ; chopping board location
    (at-delivery-point ?delivery - delivery-point ?pos - position)  ; delivery point location
    
    ;; Ingredient states
    (chopped ?ingredient - ingredient)  ; ingredient is chopped
    (holding-ingredient ?player - player ?ingredient - ingredient)  ; player holds ingredient
    (holding-mixed-ingredients ?player - player ?ingredient1 ?ingredient2 - ingredient)  ; player holds mixed ingredients
    (holding-plate ?player - player ?plate - plate)  ; player holds plate
    
    ;; Plate states
    (empty-plate ?plate - plate)  ; plate is empty
    (plate-has-mixed-ingredients ?plate - plate ?ingredient1 ?ingredient2 - ingredient)  ; plate contains mixed ingredients
    
    ;; Game state
    (hands-free ?player - player)  ; player is not holding anything
    (delivered ?plate - plate)  ; plate has been delivered
    
    ;; Position occupancy
    (position-free ?pos - position)  ; position is free for movement
  )
  
  (:action move
    :parameters (?player - player ?from ?to - position ?dir - direction)
    :precondition (and
      (at-player ?player ?from)
      (move-dir ?from ?to ?dir)
      (position-free ?to)
    )
    :effect (and
      (not (at-player ?player ?from))
      (at-player ?player ?to)
      (position-free ?from)
      (not (position-free ?to))
    )
  )
  
  (:action pick-ingredient
    :parameters (?player - player ?ingredient - ingredient ?player-pos ?ingredient-pos - position ?dir - direction)
    :precondition (and
      (at-player ?player ?player-pos)
      (at-ingredient ?ingredient ?ingredient-pos)
      (move-dir ?player-pos ?ingredient-pos ?dir)
      (hands-free ?player)
    )
    :effect (and
      (not (at-ingredient ?ingredient ?ingredient-pos))
      (not (hands-free ?player))
      (holding-ingredient ?player ?ingredient)
    )
  )
  
  (:action drop-ingredient
    :parameters (?player - player ?ingredient - ingredient ?player-pos ?drop-pos - position ?dir - direction)
    :precondition (and
      (at-player ?player ?player-pos)
      (move-dir ?player-pos ?drop-pos ?dir)
      (holding-ingredient ?player ?ingredient)
    )
    :effect (and
      (at-ingredient ?ingredient ?drop-pos)
      (hands-free ?player)
      (not (holding-ingredient ?player ?ingredient))
    )
  )
  
  (:action pick-plate
    :parameters (?player - player ?plate - plate ?player-pos ?plate-pos - position ?dir - direction)
    :precondition (and
      (at-player ?player ?player-pos)
      (at-plate ?plate ?plate-pos)
      (move-dir ?player-pos ?plate-pos ?dir)
      (hands-free ?player)
    )
    :effect (and
      (not (at-plate ?plate ?plate-pos))
      (not (hands-free ?player))
      (holding-plate ?player ?plate)
    )
  )
  
  (:action drop-plate
    :parameters (?player - player ?plate - plate ?player-pos ?drop-pos - position ?dir - direction)
    :precondition (and
      (at-player ?player ?player-pos)
      (move-dir ?player-pos ?drop-pos ?dir)
      (holding-plate ?player ?plate)
    )
    :effect (and
      (at-plate ?plate ?drop-pos)
      (hands-free ?player)
      (not (holding-plate ?player ?plate))
    )
  )
  
  (:action chop
    :parameters (?player - player ?ingredient - ingredient ?player-pos ?board-pos - position ?board - chopping-board ?dir - direction)
    :precondition (and
      (at-player ?player ?player-pos)
      (at-chopping-board ?board ?board-pos)
      (move-dir ?player-pos ?board-pos ?dir)
      (at-ingredient ?ingredient ?board-pos)
    )
    :effect (and
      (chopped ?ingredient)
    )
  )
  
  (:action merge-ingredient
    :parameters (?player - player ?ingredient1 ?ingredient2 - ingredient ?player-pos ?merge-pos - position ?dir - direction)
    :precondition (and
      (at-player ?player ?player-pos)
      (move-dir ?player-pos ?merge-pos ?dir)
      (holding-ingredient ?player ?ingredient1)
      (at-ingredient ?ingredient2 ?merge-pos)
      (chopped ?ingredient1)
      (chopped ?ingredient2)
      (not (= ?ingredient1 ?ingredient2))
    )
    :effect (and
      (not (holding-ingredient ?player ?ingredient1))
      (not (at-ingredient ?ingredient2 ?merge-pos))
      (holding-mixed-ingredients ?player ?ingredient1 ?ingredient2)
    )
  )
  
  (:action put-plate
    :parameters (?player - player ?ingredient1 ?ingredient2 - ingredient ?plate - plate ?player-pos ?plate-pos - position ?dir - direction)
    :precondition (and
      (at-player ?player ?player-pos)
      (move-dir ?player-pos ?plate-pos ?dir)
      (holding-mixed-ingredients ?player ?ingredient1 ?ingredient2)
      (at-plate ?plate ?plate-pos)
      (empty-plate ?plate)
    )
    :effect (and
      (not (holding-mixed-ingredients ?player ?ingredient1 ?ingredient2))
      (hands-free ?player)
      (not (empty-plate ?plate))
      (plate-has-mixed-ingredients ?plate ?ingredient1 ?ingredient2)
    )
  )
  
  (:action deliver
    :parameters (?player - player ?plate - plate ?ingredient1 ?ingredient2 - ingredient ?player-pos ?delivery-pos - position ?delivery - delivery-point ?dir - direction)
    :precondition (and
      (at-player ?player ?player-pos)
      (holding-plate ?player ?plate)
      (at-delivery-point ?delivery ?delivery-pos)
      (move-dir ?player-pos ?delivery-pos ?dir)
      (plate-has-mixed-ingredients ?plate ?ingredient1 ?ingredient2)
    )
    :effect (and
      (delivered ?plate)
      (hands-free ?player)
      (not (holding-plate ?player ?plate))
    )
  )
)