(define (domain printer)
  (:requirements :strips :typing)
  
  (:types
    position
    direction
    printer
  )
  
  (:predicates
    ;; Position and movement predicates
    (at ?pos - position)
    (facing ?dir - direction)
    (move-dir ?pos1 - position ?pos2 - position ?dir - direction)
    (desk-region ?pos - position)
    
    ;; Turn predicates
    (left-turn ?from - direction ?to - direction)
    (right-turn ?from - direction ?to - direction)
    
    ;; Printer predicates
    (printer-at ?pos - position)
    (holding)
    (printer-on)
    (printer-dropped-on-desk)
  )
  
  (:action turn-left
    :parameters (?current-dir - direction ?new-dir - direction)
    :precondition (and 
      (facing ?current-dir)
      (left-turn ?current-dir ?new-dir)
    )
    :effect (and 
      (not (facing ?current-dir))
      (facing ?new-dir)
    )
  )
  
  (:action turn-right
    :parameters (?current-dir - direction ?new-dir - direction)
    :precondition (and 
      (facing ?current-dir)
      (right-turn ?current-dir ?new-dir)
    )
    :effect (and 
      (not (facing ?current-dir))
      (facing ?new-dir)
    )
  )
  
  (:action move
    :parameters (?from - position ?to - position ?dir - direction)
    :precondition (and 
      (at ?from)
      (facing ?dir)
      (move-dir ?from ?to ?dir)
      (not (desk-region ?to))
    )
    :effect (and 
      (not (at ?from))
      (at ?to)
    )
  )
  
  (:action pick-up
    :parameters (?pos - position ?printerpos - position ?dir - direction)
    :precondition (and 
      (at ?pos)
      (printer-at ?printerpos)
      (not (holding))
      (facing ?dir)
      (move-dir ?pos ?printerpos ?dir)
    )
    :effect (and 
      (holding)
      (not (printer-at ?printerpos))
    )
  )
  
  (:action drop-down-nondesk
    :parameters (?pos - position ?topos - position ?dir - direction)
    :precondition (and 
      (at ?pos)
      (holding)
      (not (desk-region ?topos))
      (facing ?dir)
      (move-dir ?pos ?topos ?dir)
    )
    :effect (and 
      (not (holding))
      (printer-at ?topos)
    )
  )
  
  (:action drop-down-desk
    :parameters (?pos - position ?topos - position ?dir - direction)
    :precondition (and 
      (at ?pos)
      (holding)
      (desk-region ?topos)
      (facing ?dir)
      (move-dir ?pos ?topos ?dir)
    )
    :effect (and 
      (not (holding))
      (printer-at ?topos)
      (printer-dropped-on-desk)
    )
  )
  
  (:action toggle-on
    :parameters (?pos - position ?topos - position ?dir - direction)
    :precondition (and 
      (at ?pos)
      (printer-at ?topos)
      (not (printer-on))
      (facing ?dir)
      (move-dir ?pos ?topos ?dir)
    )
    :effect (printer-on)
  )
  
  (:action toggle-off
    :parameters (?pos - position ?topos - position ?dir - direction)
    :precondition (and 
      (at ?pos)
      (printer-at ?topos)
      (printer-on)
      (facing ?dir)
      (move-dir ?pos ?topos ?dir)
    )
    :effect (not (printer-on))
  )
)