(define (problem printer-problem-2)
  (:domain printer)
  
  (:objects
    ; Positions in 6x6 grid
    pos-1-1 pos-1-2 pos-1-3 pos-1-4 pos-1-5 pos-1-6 pos-2-1 pos-2-2 pos-2-3 pos-2-4 pos-2-5 pos-2-6 pos-3-1 pos-3-2 pos-3-3 pos-3-4 pos-3-5 pos-3-6 pos-4-1 pos-4-2 pos-4-3 pos-4-4 pos-4-5 pos-4-6 pos-5-1 pos-5-2 pos-5-3 pos-5-4 pos-5-5 pos-5-6 pos-6-1 pos-6-2 pos-6-3 pos-6-4 pos-6-5 pos-6-6 - position
    
    ; Directions
    up down left right - direction
    
    ; Printer
    the-printer - printer
  )
  
  (:init
    ; Agent initial position and orientation
    (at pos-2-6)
    (facing down)
    
    ; Printer initial position
    (printer-at pos-4-4)
    
    ; Desk region
    (desk-region pos-5-4)
    (desk-region pos-5-5)
    (desk-region pos-5-6)
    (desk-region pos-6-4)
    (desk-region pos-6-5)
    (desk-region pos-6-6)
    
    ; Turn relations
    (left-turn up left)
    (left-turn left down)
    (left-turn down right)
    (left-turn right up)
    
    (right-turn up right)
    (right-turn right down)
    (right-turn down left)
    (right-turn left up)
    
    ; Grid adjacency relationships
    (move-dir pos-1-1 pos-1-2 right) (move-dir pos-1-2 pos-1-1 left)
    (move-dir pos-1-2 pos-1-3 right) (move-dir pos-1-3 pos-1-2 left)
    (move-dir pos-1-3 pos-1-4 right) (move-dir pos-1-4 pos-1-3 left)
    (move-dir pos-1-4 pos-1-5 right) (move-dir pos-1-5 pos-1-4 left)
    (move-dir pos-1-5 pos-1-6 right) (move-dir pos-1-6 pos-1-5 left)
    (move-dir pos-2-1 pos-2-2 right) (move-dir pos-2-2 pos-2-1 left)
    (move-dir pos-2-2 pos-2-3 right) (move-dir pos-2-3 pos-2-2 left)
    (move-dir pos-2-3 pos-2-4 right) (move-dir pos-2-4 pos-2-3 left)
    (move-dir pos-2-4 pos-2-5 right) (move-dir pos-2-5 pos-2-4 left)
    (move-dir pos-2-5 pos-2-6 right) (move-dir pos-2-6 pos-2-5 left)
    (move-dir pos-3-1 pos-3-2 right) (move-dir pos-3-2 pos-3-1 left)
    (move-dir pos-3-2 pos-3-3 right) (move-dir pos-3-3 pos-3-2 left)
    (move-dir pos-3-3 pos-3-4 right) (move-dir pos-3-4 pos-3-3 left)
    (move-dir pos-3-4 pos-3-5 right) (move-dir pos-3-5 pos-3-4 left)
    (move-dir pos-3-5 pos-3-6 right) (move-dir pos-3-6 pos-3-5 left)
    (move-dir pos-4-1 pos-4-2 right) (move-dir pos-4-2 pos-4-1 left)
    (move-dir pos-4-2 pos-4-3 right) (move-dir pos-4-3 pos-4-2 left)
    (move-dir pos-4-3 pos-4-4 right) (move-dir pos-4-4 pos-4-3 left)
    (move-dir pos-4-4 pos-4-5 right) (move-dir pos-4-5 pos-4-4 left)
    (move-dir pos-4-5 pos-4-6 right) (move-dir pos-4-6 pos-4-5 left)
    (move-dir pos-5-1 pos-5-2 right) (move-dir pos-5-2 pos-5-1 left)
    (move-dir pos-5-2 pos-5-3 right) (move-dir pos-5-3 pos-5-2 left)
    (move-dir pos-5-3 pos-5-4 right) (move-dir pos-5-4 pos-5-3 left)
    (move-dir pos-5-4 pos-5-5 right) (move-dir pos-5-5 pos-5-4 left)
    (move-dir pos-5-5 pos-5-6 right) (move-dir pos-5-6 pos-5-5 left)
    (move-dir pos-6-1 pos-6-2 right) (move-dir pos-6-2 pos-6-1 left)
    (move-dir pos-6-2 pos-6-3 right) (move-dir pos-6-3 pos-6-2 left)
    (move-dir pos-6-3 pos-6-4 right) (move-dir pos-6-4 pos-6-3 left)
    (move-dir pos-6-4 pos-6-5 right) (move-dir pos-6-5 pos-6-4 left)
    (move-dir pos-6-5 pos-6-6 right) (move-dir pos-6-6 pos-6-5 left)
    (move-dir pos-1-1 pos-2-1 down) (move-dir pos-2-1 pos-1-1 up)
    (move-dir pos-1-2 pos-2-2 down) (move-dir pos-2-2 pos-1-2 up)
    (move-dir pos-1-3 pos-2-3 down) (move-dir pos-2-3 pos-1-3 up)
    (move-dir pos-1-4 pos-2-4 down) (move-dir pos-2-4 pos-1-4 up)
    (move-dir pos-1-5 pos-2-5 down) (move-dir pos-2-5 pos-1-5 up)
    (move-dir pos-1-6 pos-2-6 down) (move-dir pos-2-6 pos-1-6 up)
    (move-dir pos-2-1 pos-3-1 down) (move-dir pos-3-1 pos-2-1 up)
    (move-dir pos-2-2 pos-3-2 down) (move-dir pos-3-2 pos-2-2 up)
    (move-dir pos-2-3 pos-3-3 down) (move-dir pos-3-3 pos-2-3 up)
    (move-dir pos-2-4 pos-3-4 down) (move-dir pos-3-4 pos-2-4 up)
    (move-dir pos-2-5 pos-3-5 down) (move-dir pos-3-5 pos-2-5 up)
    (move-dir pos-2-6 pos-3-6 down) (move-dir pos-3-6 pos-2-6 up)
    (move-dir pos-3-1 pos-4-1 down) (move-dir pos-4-1 pos-3-1 up)
    (move-dir pos-3-2 pos-4-2 down) (move-dir pos-4-2 pos-3-2 up)
    (move-dir pos-3-3 pos-4-3 down) (move-dir pos-4-3 pos-3-3 up)
    (move-dir pos-3-4 pos-4-4 down) (move-dir pos-4-4 pos-3-4 up)
    (move-dir pos-3-5 pos-4-5 down) (move-dir pos-4-5 pos-3-5 up)
    (move-dir pos-3-6 pos-4-6 down) (move-dir pos-4-6 pos-3-6 up)
    (move-dir pos-4-1 pos-5-1 down) (move-dir pos-5-1 pos-4-1 up)
    (move-dir pos-4-2 pos-5-2 down) (move-dir pos-5-2 pos-4-2 up)
    (move-dir pos-4-3 pos-5-3 down) (move-dir pos-5-3 pos-4-3 up)
    (move-dir pos-4-4 pos-5-4 down) (move-dir pos-5-4 pos-4-4 up)
    (move-dir pos-4-5 pos-5-5 down) (move-dir pos-5-5 pos-4-5 up)
    (move-dir pos-4-6 pos-5-6 down) (move-dir pos-5-6 pos-4-6 up)
    (move-dir pos-5-1 pos-6-1 down) (move-dir pos-6-1 pos-5-1 up)
    (move-dir pos-5-2 pos-6-2 down) (move-dir pos-6-2 pos-5-2 up)
    (move-dir pos-5-3 pos-6-3 down) (move-dir pos-6-3 pos-5-3 up)
    (move-dir pos-5-4 pos-6-4 down) (move-dir pos-6-4 pos-5-4 up)
    (move-dir pos-5-5 pos-6-5 down) (move-dir pos-6-5 pos-5-5 up)
    (move-dir pos-5-6 pos-6-6 down) (move-dir pos-6-6 pos-5-6 up)
  )
  
  (:goal
    (and
      (printer-dropped-on-desk)
      (printer-on)
    )
  )
)