#ImplicitReasoning

def resnetBlockFC(inputs, hidden_size = 256):
    fc0 = tf.layers.dense(tf.nn.relu(inputs),hidden_size)
    fc1 = tf.layers.dense(tf.nn.relu(fc0),hidden_size)
    return inputs + fc1

def create_model_decoder(self, feature_input, input_points, target_points_lable, p_points, e_points, line_points, x0, y0, z0, global_):
    # feature_input is condition of a shape, input_points are 3D locations of the grid cells, 
    # p_points: rays starting from a pixel with a value of p_points, line_points is the number of ray in a batch, global_ is epoch
    with tf.variable_scope('decoder', reuse=tf.AUTO_REUSE):
        c = tf.layers.dense(feature_input,128)
        p_embed = tf.layers.dense(input_points,128)
        output = tf.concat([c, p_embed],1)
        for i in range(5):
            with tf.variable_scope("resnetBlockFC_%d" % i ):
                output = resnetBlockFC(output)
        result = tf.layers.dense(tf.nn.relu(output),1)
        result_sigmoid = tf.sigmoid(result)
        
    result_sigmoid_line = tf.reshape(result_sigmoid,[line_points,-1])
    x = tf.reduce_sum(result_sigmoid_line,axis = 1)
    y = tf.reduce_mean(result_sigmoid_line, 1)

    l1 = tf.reduce_mean(tf.exp(-x) * p_points)
    l2 = tf.reduce_mean(WEIGHT*(1-p_points)*y)
    loss = tf.reduce_mean(l1 + l2)

    lr = tf.train.exponential_decay(LR, global_, 64000, 0.99, staircase = True)
    optimizer = tf.train.AdamOptimizer(learning_rate=lr)
    t_vars = tf.trainable_variables()
    train_step = optimizer.minimize(loss,var_list = t_vars)
