#!/bin/bash
CURRENT_DATE=$(date +%Y%m%d)
RANDOM_STRING="${CURRENT_DATE}-$(cat /dev/urandom | tr -dc 'a-zA-Z0-9' | fold -w 3 | head -n 1)"

# Setting
DASET=$1
CATEG=$2
EXP=$3
ANS_DIR=$4
ANS_MARK=$5
GPU=${6//[^0-9]/}

# --answer-file-ver \"${DASET}.${CATEG}.${RANDOM_STRING}\" \
CMD="python Users/python/execute.py --gpu $GPU \
--exp-config Users/exps/${EXP}.yml \
--daset $DASET \
--answer-file-ver \"$( [ -n "${ANS_DIR}" ] && echo "${ANS_DIR}/" )${DASET}.${CATEG}$( [ -n "${ANS_MARK}" ] && echo ".${ANS_MARK}" ).${RANDOM_STRING}\" \
--category $CATEG \
--question-file daset/$DASET/Questions \
--image-folder daset/$DASET/Images \
--conv-mode vicuna_v1"

echo "DASET=$DASET CATEG=$CATEG EXP=$EXP ANSDIR=$ANS_DIR ANS_MARK=$ANS_MARK GPU=$GPU"
# Execute the command
eval $CMD