__all__ = ['getLabelMap', 'S40', 'UCF101', 'EAD', 'HMDB', 'BU101','HMDB_FULL']

ucfLabelIdxNameMap = {
    0: 'WritingOnBoard',
    1: 'WalkingWithDog',
    2: 'BrushingTeeth',
    3: 'MoppingFloor',
    4: 'RockClimbingIndoor',
    5: 'Archery',
    6: 'Rowing',
    7: 'CuttingInKitchen',
    8: 'HorseRiding',
    9: 'Biking',
    10: 'PlayingGuitar',
    11: 'PlayingViolin',
}

bu101LabelIdxNameMap = {
    0: 'WritingOnBoard',
    1: 'WalkingWithDog',
    2: 'BrushingTeeth',
    3: 'MoppingFloor',
    4: 'RockClimbingIndoor',
    5: 'Archery',
    6: 'Rowing',
    7: 'CuttingInKitchen',
    8: 'HorseRiding',
    9: 'Biking',
    10: 'PlayingGuitar',
    11: 'PlayingViolin',
    12: 'BenchPress',
    13: 'Billiards',
    14: 'BlowDryHair',
    15: 'BlowingCandles',
    16: 'BodyWeightSquats',
    17: 'Bowling',
    18: 'Basketball',
    19: 'BasketballDunk',
    20: 'BoxingPunchingBag',
    21: 'BoxingSpeedBag',
    22: 'BreastStroke',
    23: 'CleanAndJerk',
    24: 'BaseballPitch',
    25: 'BandMarching',
    26: 'BalanceBeam',
    27: 'CliffDiving',
    28: 'BabyCrawling',
    29: 'CricketBowling',
    30: 'CricketShot',
    31: 'Diving',
    32: 'Drumming',
    33: 'Fencing',
    34: 'ApplyLipstick',
    35: 'FieldHockeyPenalty',
    36: 'FloorGymnastics',
    37: 'FrisbeeCatch',
    38: 'ApplyEyeMakeup',
    39: 'FrontCrawl',
    40: 'GolfSwing',
    41: 'Haircut',
    42: 'HammerThrow',
    43: 'Hammering',
    44: 'HandstandPushups',
    45: 'HandstandWalking',
    46: 'HeadMassage',
    47: 'HighJump',
    48: 'HorseRace',
    49: 'HulaHoop',
    50: 'IceDancing',
    51: 'JavelinThrow',
    52: 'JugglingBalls',
    53: 'JumpRope',
    54: 'JumpingJack',
    55: 'Kayaking',
    56: 'Knitting',
    57: 'LongJump',
    58: 'Lunges',
    59: 'MilitaryParade',
    60: 'Mixing',
    61: 'Nunchucks',
    62: 'ParallelBars',
    63: 'PizzaTossing',
    64: 'PlayingCello',
    65: 'PlayingDaf',
    66: 'PlayingDhol',
    67: 'PlayingFlute',
    68: 'PlayingPiano',
    69: 'PlayingSitar',
    70: 'PlayingTabla',
    71: 'PoleVault',
    72: 'PommelHorse',
    73: 'PullUps',
    74: 'Punch',
    75: 'PushUps',
    76: 'Rafting',
    77: 'RopeClimbing',
    78: 'SalsaSpin',
    79: 'ShavingBeard',
    80: 'Shotput',
    81: 'SkateBoarding',
    82: 'Skiing',
    83: 'Skijet',
    84: 'SkyDiving',
    85: 'SoccerJuggling',
    86: 'SoccerPenalty',
    87: 'StillRings',
    88: 'SumoWrestling',
    89: 'Surfing',
    90: 'Swing',
    91: 'TableTennisShot',
    92: 'TaiChi',
    93: 'TennisSwing',
    94: 'ThrowDiscus',
    95: 'TrampolineJumping',
    96: 'Typing',
    97: 'UnevenBars',
    98: 'VolleyballSpiking',
    99: 'WallPushups',
    100: 'YoYo',
}

s40LabelIdxNameMap = {
    0: 'writing_on_a_board',
    1: 'walking_the_dog',
    2: 'brushing_teeth',
    3: 'cleaning_the_floor',
    4: 'climbing',
    5: 'shooting_an_arrow',
    6: 'rowing_a_boat',
    7: 'cutting_vegetables',
    8: 'riding_a_horse',
    9: 'riding_a_bike',
    10: 'playing_guitar',
    11: 'playing_violin',
    12: 'fixing_a_car',
    13: 'gardening',
    14: 'holding_an_umbrella',
    15: 'jumping',
    16: 'looking_through_a_microscope',
    17: 'looking_through_a_telescope',
    18: 'fishing',
    19: 'fixing_a_bike',
    20: 'pouring_liquid',
    21: 'pushing_a_cart',
    22: 'reading',
    23: 'phoning',
    24: 'feeding_a_horse',
    25: 'drinking',
    26: 'cutting_trees',
    27: 'running',
    28: 'cooking',
    29: 'smoking',
    30: 'taking_photos',
    31: 'texting_message',
    32: 'throwing_frisby',
    33: 'using_a_computer',
    34: 'blowing_bubbles',
    35: 'washing_dishes',
    36: 'watching_TV',
    37: 'waving_hands',
    38: 'applauding',
    39: 'writing_on_a_book',
}

eadLabelIdxNameMap = {
    0: 'clap',
    1: 'climb',
    2: 'drink',
    3: 'hug',
    4: 'jump',
    5: 'kick',
    6: 'kiss',
    7: 'pour',
    8: 'push',
    9: 'run',
    10: 'smoke',
    11: 'talk',
    12: 'wave',
    13: 'Archery',
    14: 'Biking',
    15: 'blowing_bubbles',
    16: 'Boxing-Punching',
    17: 'BrushingTeeth',
    18: 'cooking',
    19: 'cutting_trees',
    20: 'CuttingInKitchen',
    21: 'Dining',
    22: 'feeding_a_horse',
    23: 'fishing',
    24: 'fixing_a_bike',
    25: 'fixing_a_car',
    26: 'gardening',
    27: 'Handshaking',
    28: 'HighFive',
    29: 'holding_an_umbrella',
    30: 'HorseRiding',
    31: 'looking_through_a_microscope',
    32: 'looking_through_a_telescope',
    33: 'MoppingFloor',
    34: 'Partying',
    35: 'phoning',
    36: 'PlayingGuitar',
    37: 'PlayingViolin',
    38: 'reading',
    39: 'Rowing',
    40: 'Speech',
    41: 'taking_photos',
    42: 'texting_message',
    43: 'throwing_frisby',
    44: 'using_a_computer',
    45: 'WalkingWithDog',
    46: 'washing_dishes',
    47: 'watching_TV',
    48: 'writing_on_a_book',
    49: 'WritingOnBoard',
}

hmdbLabelIdxNameMap = {
    0: 'clap',
    1: 'climb',
    2: 'drink',
    3: 'hug',
    4: 'jump',
    5: 'kick',
    6: 'kiss',
    7: 'pour',
    8: 'push',
    9: 'run',
    10: 'smoke',
    11: 'talk',
    12: 'wave',
}

hmdbLabelIdxNameMap_full = {
    0: 'clap',
    1: 'climb',
    2: 'drink',
    3: 'hug',
    4: 'jump',
    5: 'kick',
    6: 'kiss',
    7: 'pour',
    8: 'push',
    9: 'run',
    10: 'smoke',
    11: 'talk',
    12: 'wave',
    13: 'brush_hair',
    14: 'cartwheel',
    15: 'catch',
    16: 'chew',
    17: 'climb_stairs',
    18: 'dive',
    19: 'draw_sword',
    20: 'dribble',
    21: 'eat',
    22: 'fall_floor',
    23: 'fencing',
    24: 'flic_flac',
    25: 'golf',
    26: 'handstand',
    27: 'hit',
    28: 'kick_ball',
    29: 'laugh',
    30: 'pick',
    31: 'pullup',
    32: 'punch',
    33: 'pushup',
    34: 'ride_bike',
    35: 'ride_horse',
    36: 'shake_hands',
    37: 'shoot_ball',
    38: 'shoot_bow',
    39: 'shoot_gun',
    40: 'sit',
    41: 'situp',
    42: 'smile',
    43: 'somersault',
    44: 'stand',
    45: 'swing_baseball',
    46: 'sword',
    47: 'sword_exercise',
    48: 'throw',
    49: 'turn',
    50: 'walk'
}

S40 = 's40'
UCF101 = 'ucf'
EAD = 'ead'
HMDB = 'hmdb'
BU101 = 'bu101'
HMDB_FULL = 'hmdb_full'


def getLabelMap(dataset_name: str):
    if dataset_name.lower() in (S40):
        labelIdxNameMap = s40LabelIdxNameMap
    elif dataset_name.lower() in (UCF101):
        labelIdxNameMap = ucfLabelIdxNameMap
    elif dataset_name.lower() in (EAD):
        labelIdxNameMap = eadLabelIdxNameMap
    elif dataset_name.lower() in (HMDB):
        labelIdxNameMap = hmdbLabelIdxNameMap
    elif dataset_name.lower() in (BU101):
        labelIdxNameMap = bu101LabelIdxNameMap
    elif dataset_name.lower() in (HMDB_FULL):
        labelIdxNameMap = hmdbLabelIdxNameMap_full

    labelIdxNameMap = {k: v for k, v in labelIdxNameMap.copy().items()}
    labelNameIdxMap = {v: k for k, v in labelIdxNameMap.items()}
    return labelIdxNameMap, labelNameIdxMap
