REPO=/home/yuren/mycontainer/model/xtreme_resource
DIR=$REPO/data/
CODE=/home/yuren/mycontainer/model/lf-mlf/xtreme

function process_panx {
    echo "processing panx_datset"
    # if [ -f $DIR/AmazonPhotos.zip ]; then
    base_dir=$DIR/panx_dataset/
    # unzip -qq -j $DIR/AmazonPhotos.zip -d $base_dir
    cd $base_dir
    langs=(ar he vi id jv ms tl eu ml ta te af nl en de el bn hi mr ur fa fr it pt es bg ru ja ka ko th sw yo my zh kk tr et fi hu qu pl uk az lt pa gu ro)
    for lg in ${langs[@]}; do
        tar xzf $base_dir/${lg}.tar.gz
        for f in dev test train; do mv $base_dir/$f $base_dir/${lg}-${f}; done
    done
    cd ..
    python $CODE/utils_preprocess.py \
        --data_dir $base_dir \
        --output_dir $DIR/panx \
        --task panx
    # rm -rf $base_dir
    echo "Successfully downloaded data at $DIR/panx" >> $DIR/download.log
}

process_panx