
# : ${SUITE:=$(date '+%Y-%m-%d-%M')}
SUITE="2024-01-16-12"
: ${CUDA_VISIBLE_DEVICES:=7}
: ${name:=moe}

function run_finetune(){
PORT=$(shuf -i7000-9000 -n1)

server_command="source activate lla;\
CUDA_VISIBLE_DEVICES=$CUDA_VISIBLE_DEVICES \
individual=$src \
uvicorn run_merge:app --port $PORT | tee $name.log"

helm_command="SHOW=1 \
OUTPUT=/home/xx/twin-merge/qwen/outs \
NAME=$src \
SUITE=$SUITE \
CONF=moe \
PORT=$PORT \
bash $xx_HOME/helm/eval_http.sh "

tmux_name=qwen-$src
tmux new-session -ds $tmux_name
tmux list-panes -t $tmux_name:0.1 > /dev/null 2>&1
if [ $? -ne 0 ]; then
    # tmux_name:0.1 不存在，执行 split 操作
    tmux split-window -h -t $tmux_name:0.0
fi
tmux send-keys -t $tmux_name:0.0 "$server_command" C-m
tmux send-keys -t $tmux_name:0.1 "$helm_command" C-m
# tmux a -t $tmux_name

# kill_process_by_name "run_merge:app --port $PORT"
}


function run_merged(){

PORT=$(shuf -i7000-9000 -n1)

server_command="source activate lla;\
CUDA_VISIBLE_DEVICES=$CUDA_VISIBLE_DEVICES \
select_merge=$select_merge \
src_merge=$src_merge \
yaml_file=/home/xx/twin-merge/roberta/config/$merge.yml \
uvicorn run_merge:app --port $PORT | tee $name.log"

# : ${SUITE:=$(date '+%Y-%m-%d-%M')}

helm_command="SHOW=1 \
OUTPUT=/home/xx/twin-merge/qwen/outs \
NAME=$select_merge-$merge \
SUITE=$SUITE \
CONF=moe \
PORT=$PORT \
bash $xx_HOME/helm/eval_http.sh "

tmux_name=$select_merge-$merge-$info
tmux new-session -ds $tmux_name
tmux list-panes -t $tmux_name:0.1 > /dev/null 2>&1
if [ $? -ne 0 ]; then
    # tmux_name:0.1 不存在，执行 split 操作
    tmux split-window -h -t $tmux_name:0.0
fi
tmux send-keys -t $tmux_name:0.0 "$server_command" C-m
tmux send-keys -t $tmux_name:0.1 "$helm_command" C-m
# tmux a -t $tmux_name

}


function run_pretrained(){
PORT=$(shuf -i7000-9000 -n1)

server_command="source activate lla;\
pretrained=1 \
CUDA_VISIBLE_DEVICES=$CUDA_VISIBLE_DEVICES \
uvicorn run_merge:app --port $PORT | tee $name.log"

# : ${SUITE:=$(date '+%Y-%m-%d-%M')}

helm_command="SHOW=1 \
OUTPUT=/home/xx/twin-merge/qwen/outs \
NAME=pretrained \
SUITE=$SUITE \
CONF=moe \
PORT=$PORT \
bash $xx_HOME/helm/eval_http.sh "

tmux_name=pretrained
tmux new-session -ds $tmux_name
tmux list-panes -t $tmux_name:0.1 > /dev/null 2>&1
if [ $? -ne 0 ]; then
    # tmux_name:0.1 不存在，执行 split 操作
    tmux split-window -h -t $tmux_name:0.0
fi
tmux send-keys -t $tmux_name:0.0 "$server_command" C-m
tmux send-keys -t $tmux_name:0.1 "$helm_command" C-m
# tmux a -t $tmux_name


kill_process_by_name() {
    local process_name="$1"
    
    # Use pgrep to find the process IDs (PIDs) based on the name
    local pids=$(pgrep -f "$process_name")
    
    if [ -n "$pids" ]; then
        # Use pkill to kill the processes by their PIDs
        pkill -f "$process_name"
        echo "Processes with name '$process_name' killed."
    else
        echo "No processes found with name '$process_name'."
    fi
}

# kill_process_by_name "run_merge:app --port $PORT"
}

# CUDA_VISIBLE_DEVICES=1 src=cnn-dm run_finetune &
# CUDA_VISIBLE_DEVICES=2 src=truthfulqa run_finetune &
# CUDA_VISIBLE_DEVICES=3 src=bbq run_finetune &
# CUDA_VISIBLE_DEVICES=0 src=mmlu run_finetune &
# CUDA_VISIBLE_DEVICES=5 select_merge=4 run_merged 
# CUDA_VISIBLE_DEVICES=5 select_merge=4 merge=task_arithmetic run_merged 
# CUDA_VISIBLE_DEVICES=0 select_merge=2 run_merged 
# CUDA_VISIBLE_DEVICES=1 select_merge=3 run_merged &
function merge(){
CUDA_VISIBLE_DEVICES=5 select_merge=4 merge=task_arithmetic run_merged 
CUDA_VISIBLE_DEVICES=2 select_merge=4 merge=average_merge run_merged 
CUDA_VISIBLE_DEVICES=3 select_merge=4 merge=ties_merge run_merged 
CUDA_VISIBLE_DEVICES=4 select_merge=4 merge=roberta_merge run_merged 
CUDA_VISIBLE_DEVICES=5 select_merge=4 merge=roberta_merge2 run_merged 
}

# CUDA_VISIBLE_DEVICES=1 run_pretrained &


function run_ood_17(){
dataset=("mmlu" "truthfulqa" "bbq" "cnn-dm" 'gsm8k')
src_merge="${dataset[$i]},${dataset[$j]}"

echo $src_merge
SUITE="qwen-ood-17-$src_merge"
# CUDA_VISIBLE_DEVICES=0 select_merge=2 info=$src_merge src_merge=$src_merge merge=task_arithmetic run_merged 
# CUDA_VISIBLE_DEVICES=1 select_merge=2 info=$src_merge src_merge=$src_merge merge=ties_merge run_merged 
# CUDA_VISIBLE_DEVICES=2 select_merge=2 info=$src_merge src_merge=$src_merge merge=roberta_merge run_merged 
# CUDA_VISIBLE_DEVICES=3 select_merge=2 info=$src_merge src_merge=$src_merge merge=roberta_merge2 run_merged 
select_merge=2 info=$src_merge src_merge=$src_merge merge=average_merge run_merged 
}


# CUDA_VISIBLE_DEVICES=1  i=0 j=1 run_ood_17
# CUDA_VISIBLE_DEVICES=2  i=0 j=2 run_ood_17
# CUDA_VISIBLE_DEVICES=3  i=0 j=3 run_ood_17
# CUDA_VISIBLE_DEVICES=4  i=1 j=2 run_ood_17
# CUDA_VISIBLE_DEVICES=5  i=1 j=3 run_ood_17
# CUDA_VISIBLE_DEVICES=5  i=2 j=3 run_ood_17
# CUDA_VISIBLE_DEVICES=1 src=mmlu run_finetune
# CUDA_VISIBLE_DEVICES=2 src=truthfulqa run_finetune
# CUDA_VISIBLE_DEVICES=3 src=cnn-dm run_finetune
# CUDA_VISIBLE_DEVICES=4 src=bbq run_finetune
merge

