source activate lla
set -e pipefail

date_today=$(date '+%Y-%m-%d')
outdir=${outdir:="outs/merge_${date_today}"}
mkdir -p ${outdir}

models_name=(
"cola"
"sst2"
"mrpc"
"stsb"
"qqp"
"mnli"
"qnli"
"rte"
)
models_to_merge=()
for d in "${models_name[@]}"; do
models_to_merge+=($xx_HOME/twin-merge/MergeLM/save_models/$d/roberta-base_lr1e-05)
done

select_merge=${select_merge:="8"}

if [ $select_merge -eq 1 ]; then
    echo "please set \$select_merge > 1"
    exit 1 
fi
src_merge=("${models_name[@]:0:$select_merge}") 

echo ">>> merged from $select_merge tasks"

function run_dare_task_arith(){

for i in 0.7 0.8 0.9; do

python run_merge.py \
--models-to-merge ${models_to_merge[@]} \
--models-name ${models_name[@]} \
--src-merge ${src_merge[@]} \
--yaml-file config/dare_merge.yml \
--exclude-param ".*classifier.*" ".*bias.*"  \
--mask-rate $i \
--outdir $outdir

done

}

function run_dare_tie(){

for i in 0.7 0.8 0.9; do

python run_merge.py \
--models-to-merge ${models_to_merge[@]} \
--models-name ${models_name[@]} \
--src-merge ${src_merge[@]} \
--yaml-file config/dare_merge2.yml \
--exclude-param ".*classifier.*" ".*bias.*"  \
--mask-rate $i \
--outdir $outdir

done

}


function run_avg_merge(){

python run_merge.py \
--models-to-merge ${models_to_merge[@]} \
--models-name ${models_name[@]} \
--src-merge ${src_merge[@]} \
--yaml-file config/average_merge.yml \
--exclude-param ".*classifier.*" ".*bias.*"  \
--outdir $outdir


}

function run_tie(){

for i in 0.7 0.8 0.9; do
for j in 0.7 0.9; do

python run_merge.py \
--models-to-merge ${models_to_merge[@]} \
--models-name ${models_name[@]} \
--src-merge ${src_merge[@]} \
--yaml-file config/ties_merge.yml \
--exclude-param ".*classifier.*" ".*bias.*"  \
--mask-rate $i \
--scaling $j \
--outdir $outdir

done
done

}


function run_task_arith(){

for j in 0.1 0.3 0.5 0.7 0.9 1.0; do

python run_merge.py \
--models-to-merge ${models_to_merge[@]} \
--models-name ${models_name[@]} \
--src-merge ${src_merge[@]} \
--yaml-file config/task_arithmetic.yml \
--exclude-param ".*classifier.*" ".*bias.*"  \
--scaling $j \
--outdir $outdir

done

}

function base(){

python run_merge.py \
--models-to-merge ${models_to_merge[@]} \
--models-name ${models_name[@]} \
--base-model 'roberta-base' \
--exclude-param ".*classifier.*" ".*bias.*" \
--outdir $outdir 

}

function pretrain(){

python run_merge.py \
--models-to-merge 'NONE' \
--models-name 'NONE' \
--base-model 'roberta-base' \
--outdir $outdir 

}


# base
# CUDA_VISIBLE_DEVICES=6 run_dare_task_arith &
# CUDA_VISIBLE_DEVICES=7 run_dare_tie &
# CUDA_VISIBLE_DEVICES=3 run_avg_merge &
# CUDA_VISIBLE_DEVICES=4 run_task_arith &
# CUDA_VISIBLE_DEVICES=5 run_tie &