import express from "express";
import type { Request, Response } from "express";
import { createAgent, getEnvironment } from "./agent";

const app = express();
app.use(express.json());

app.post("/stream", async (_req: Request, res: Response) => {
  try {
    const env = getEnvironment();
    const agent = createAgent(env);
    const prompt = env.prompt?.[env.promptingStrategy] ?? "";
    const parsedSeed = Number(process.env.SEED);
    const seed = Number.isFinite(parsedSeed) ? parsedSeed : undefined;

    process.stdout.write(`START: ${prompt}\n`);

    res.setHeader("Content-Type", "text/plain; charset=utf-8");
    res.setHeader("Cache-Control", "no-cache, no-transform");
    res.setHeader("Connection", "keep-alive");

    const result = agent.stream({
      prompt: prompt,
      providerOptions: {
        openrouter: {
          reasoning: { effort: "high" },
          include_reasoning: true,
          ...(typeof seed === "number" ? { seed } : {}),
        },
      },
    });
    let buffer = "";
    for await (const chunk of result.textStream) {
      const text = typeof chunk === "string" ? chunk : String(chunk);
      buffer += text;
      res.write(text);
    }
    res.end();
    process.stdout.write(`[AGENTOUT] ${buffer}\n`);
  } catch (err) {
    res
      .status(500)
      .json({ error: err instanceof Error ? err.message : String(err) });
  }
});

const port = Number(process.env.PORT ?? 3000);
app.listen(port, () => {
  process.stdout.write(`server listening on :${port}\n`);
});
