import { defineConfig } from "tsup";
import copy from "esbuild-plugin-copy";

export default defineConfig({
  entry: ["src/index.ts"],
  format: ["esm"],
  target: "node20",
  clean: true,
  sourcemap: true,
  splitting: false,
  dts: false,
  esbuildPlugins: [
    copy({
      resolveFrom: "cwd",
      assets: [{ from: "src/experiments/**/*", to: "dist/experiments" }],
    }),
  ],
});
