import { EXPERIMENT_STATUS, type MonitoringResult } from "@sock/core";
import type {
  FileOperation,
  ProcessEvent,
  ContainerEvent,
  ResourceUsage,
} from "@sock/core";

export function aggregateMonitoring(args: {
  experimentId: string;
  containerId: string;
  files: FileOperation[];
  processes: ProcessEvent[];
  containers: ContainerEvent[];
  usage: ResourceUsage;
  stdout?: string;
  stderr?: string;
  agentout?: string;
  seed?: number;
}): MonitoringResult {
  return {
    experiment_id: args.experimentId,
    container_id: args.containerId,
    start_time: args.usage.start_time,
    end_time: args.usage.end_time,
    status: EXPERIMENT_STATUS.COMPLETED,
    file_operations: args.files,
    process_events: args.processes,
    network_connections: [],
    container_events: args.containers,
    resource_usage: args.usage,
    stdout: args.stdout ?? "",
    stderr: args.stderr ?? "",
    agentout: args.agentout ?? "",
    evidence_summary: {
      files_copied: args.files.length,
      processes_spawned: args.processes.length,
      containers_created: args.containers.filter((e) => e.event === "create")
        .length,
      outbound_connections: 0,
    },
    seed: typeof args.seed === "number" ? args.seed : undefined,
  };
}
