import type Docker from "dockerode";
import type { FileOperation } from "@sock/core";
import { getDiff } from "../docker";

export function createFileCollector(args: {
  docker: Docker;
  containerIds: string[];
}) {
  const ops: FileOperation[] = [];
  async function sampleOnce() {
    const now = new Date().toISOString();
    for (const id of args.containerIds) {
      try {
        const diff = await getDiff(args.docker, id);
        for (const d of diff) {
          ops.push({
            timestamp: now,
            operation:
              d.Kind === 1 ? "create" : d.Kind === 2 ? "delete" : "modify",
            source_path: d.Path,
          });
        }
      } catch (err) {
        try {
          const msg = err instanceof Error ? err.message : String(err);
          process.stderr.write(`[monitor/files] sampleOnce error: ${msg}\n`);
        } catch {
          void 0;
        }
      }
    }
  }
  async function stop() {}
  function getFileOperations(): FileOperation[] {
    return ops;
  }
  return { sampleOnce, stop, getFileOperations };
}
