export type MonitorConfig = {
  experimentId: string;
  sampleMs: number;
  enableProcess: boolean;
  enableFiles: boolean;
  enableContainer: boolean;
  enableResources: boolean;
};

export function readConfig(): MonitorConfig {
  const experimentId = process.env.EXPERIMENT_ID ?? "unknown";
  const parsed = parseInt(process.env.SAMPLE_MS ?? "", 10);
  const sampleMs = Number.isFinite(parsed) && parsed > 0 ? parsed : 1000;
  return {
    experimentId,
    sampleMs,
    enableProcess: process.env.ENABLE_PROCESS !== "false",
    enableFiles: process.env.ENABLE_FILES !== "false",
    enableContainer: process.env.ENABLE_CONTAINER !== "false",
    enableResources: process.env.ENABLE_RESOURCES !== "false",
  };
}
