import type { MonitoringResult } from "@sock/core";
import { ensureRequiredImages } from "./modules/images";
import {
  createNetwork,
  startContainers,
  stopMonitorAndCollect,
  cleanup,
  appendFileOpsFromDiff,
  waitForExperiment,
} from "./modules/orchestrator";
import type { RunArgs } from "./types";

export async function runExperiment(args: RunArgs): Promise<MonitoringResult> {
  await ensureRequiredImages(args.config);
  const { docker, networkId, networkName } = await createNetwork();
  const { containerIds } = await startContainers(docker, networkName, args);
  try {
    await waitForExperiment(docker, containerIds, args);
    let monitoring = await stopMonitorAndCollect(docker, containerIds, args);
    const agentId = containerIds["agent"];
    if (agentId) {
      monitoring = await appendFileOpsFromDiff(docker, agentId, monitoring);
    }
    return monitoring;
  } finally {
    await cleanup(docker, containerIds, networkId);
  }
}
