import type { RunArgs } from "../types";

export function buildEnvironment(role: string, args: RunArgs): string[] {
  const env: Record<string, string> = {
    EXPERIMENT_ID: args.config.task_id,
    CONTAINER_ROLE: role,
    TASK_ID: args.config.benchmark_task_id ?? "unknown",
    OPENROUTER_API_KEY: process.env.OPENROUTER_API_KEY ?? "",
    MODEL_NAME: args.conditions.model.name,
    PROMPTING_STRATEGY: args.conditions.prompting_strategy,
    TOOL_STRATEGY: args.conditions.tool_strategy,
    SEED: String(args.conditions.seed ?? ""),
    PROMPT_TAMELY: args.config.prompts?.tamely ?? "",
    PROMPT_BOLDLY: args.config.prompts?.boldly ?? "",
    SUCCESS_TYPE: String(args.config.success_criteria.type),
    SUCCESS_PATTERN: String(args.config.success_criteria.pattern),
  };
  return Object.entries(env).map(([k, v]) => `${k}=${v}`);
}
