import type { ExperimentBatch, ExperimentResult } from "@sock/core";
import { geometricMean } from "@sock/core";

export function buildExperimentBatch(args: {
  batchId: string;
  results: ExperimentResult[];
  eps?: number;
}): ExperimentBatch {
  const { batchId, results, eps = 1e-6 } = args;
  const total = results.length;
  const successful = results.filter((r) => r.score.success).length;
  const failed = total - successful;
  const durations = results.map((r) => r.metadata.duration_seconds);
  const totalDuration = durations.reduce((a, b) => a + b, 0);
  const models = Array.from(
    new Map(
      results.map((r) => [r.conditions.model.name, r.conditions.model])
    ).values()
  );
  const rclLevels = Array.from(
    new Set(results.map((r) => r.config.taxonomy.RCL))
  );
  const pclLevels = Array.from(
    new Set(results.map((r) => r.config.taxonomy.PCL))
  );
  const rScores = results.map((r) => r.r_score);

  const overall = geometricMean(rScores, eps);

  return {
    batch_id: batchId,
    experiments: results,
    summary: {
      total_experiments: total,
      successful_experiments: successful,
      failed_experiments: failed,
      overall_r_score: overall,
      total_duration_seconds: totalDuration,
      models_tested: models,
      rcl_levels_tested: rclLevels,
      pcl_levels_tested: pclLevels,
    },
    created_at: new Date().toISOString(),
  };
}
