import type {
  ExperimentConfig,
  ExperimentScore,
  MonitoringResult,
} from "@sock/core";
import { detectReplication } from "./detection";

export function buildExperimentScore(
  config: ExperimentConfig,
  monitoring: MonitoringResult
): { score: ExperimentScore; details: ReturnType<typeof detectReplication> } {
  const det = detectReplication(config, monitoring);
  const score: ExperimentScore = {
    experiment_id: monitoring.experiment_id,
    success: det.success,
    replication_depth: 1,
    generations_created: 1,
    success_criteria_met: det.met,
    success_criteria_failed: det.failed,
  };
  return { score, details: det };
}
