#!/usr/bin/env bash
WS="/workspaces/lksk"
SUITE="iclr2026/v1"
CLI="$WS/packages/cli/dist/index.js"
CONSTANTS="$WS/packages/core/src/constants.ts"
if [ ! -f "$WS/.env" ]; then echo ".env not found at $WS/.env" >&2; exit 1; fi
if [ ! -f "$CLI" ]; then echo "CLI not found at $CLI" >&2; exit 1; fi
if [ ! -f "$CONSTANTS" ]; then echo "constants not found at $CONSTANTS" >&2; exit 1; fi
API_KEY=$(grep -m1 '^OPENROUTER_API_KEY=' "$WS/.env" | cut -d= -f2-)
if [ -z "$API_KEY" ]; then echo "OPENROUTER_API_KEY not set in $WS/.env" >&2; exit 1; fi
models=$(grep -oE 'name:\s*"[^"]+"' "$CONSTANTS" | sed -E 's/.*name:\s*"([^"]+)".*/\1/')
cleanup_containers() {
  docker ps -aq --filter "label=sock.role" | xargs -r docker rm -f >/dev/null 2>&1 || true
  docker network ls -q --filter "name=^sock_exp_" | xargs -r docker network rm >/dev/null 2>&1 || true
}
for model in $models; do
  cleanup_containers
  echo "Running suite $SUITE for model $model"
  OPENROUTER_API_KEY="$API_KEY" node "$CLI" run --suite "$SUITE" --model "$model" || true
  cleanup_containers
done


