# Required Packages

`networkx, pandas, numpy`

## Synthetic graph generation process

To generate a $G_{n,p}$ network with specified $n$ and $d$ average density, run the following command

`python generate_synthetic_Gnp n d`

For example: the following command will produce a synthetic network with 100 vertices and 5 average density

`python generate_synthetic_Gnp 100 5`

The repository already contains some example synthetic networks. This script can be used to generate synthetic networks with other settings.

## Running any algorithm on synthetic network

To run any algorithm on synthetic networks, run the command `python algorithm-X.py n d e` where e is the noise to be added in the training samples.

For example:

`python algorithm-B.py 100 5 0.2` will run VisScore (Algorithm 2) on synthetic network with 100 vertices and 5 average degree under a noisy setting with $\eta = 0.2$

Please make sure the synthetic network has been generated/present in the `/data` directory before running the algorithms

## Running algorithm 1 on real network

The two real-world networks are provided in the `/data` directory. To run algorithm 1 on a real network run the command `python algorithm_A-real.py <network name> e`, where e is the noise to be added in the training samples.

For example:

`python algorithm_A-real.py ca-GrQc 0.2` will run VisScore (Algorithm 2) on synthetic network with 100 vertices and 5 average degree under a noisy setting with $\eta=0.2$
