import numpy as np
import random
import pandas as pd
from file_paths_and_consts import *
import sys
import networkx as nx
import time

'''We consider vertex index starts from 0
first read the graph file and find out the number of vertices'''
def get_vertice_num(graph_file):
    mx = -1
    with open(graph_file) as f:
        for line in f:
            v_list = [int(i) for i in line.split()]
            assert len(v_list)==2 , "wrong file format"
            mx = max(mx, max(v_list[0],v_list[1]))
    return mx

'''Read Graph and create adjacency list'''
def read_graph(graph_file,one_indexed=1):
    n = get_vertice_num(graph_file)
    G = []
    for i in range(n):
        G.append([])
    with open(graph_file) as f:
        for line in f:
            edge = [int(i) for i in line.split()]
            #assert len(v_list)==2 , "wrong file format" -- already checked in previous call
            #print(edge[0],edge[1])
            G[edge[0]-one_indexed].append(edge[1]-one_indexed)
            G[edge[1]-one_indexed].append(edge[0]-one_indexed)
    return G,n

'''create thresholds for each vertices'''
def init_Tau(G,n):
    thresholds = []
    for v in range(0,n):
        deg = len(G[v])
        thresh = np.random.randint(0,deg+2,size=1)[0]
        thresholds.append(thresh)
    return thresholds
    
n = int(sys.argv[1])
d = int(sys.argv[2])
print(n,end='')
start = time.time()

estimate_p = float(d)/float(n-1)
#print(n,d,estimate_p)
G = nx.gnp_random_graph(n,estimate_p)

M = dict()
for i in range(0,n):
    M[i] = i+1

G = nx.relabel_nodes(G, M)
nx.write_edgelist(G, SYNTH_GRAP_PATH+f'Gnp/G-{n}-deg-{d}.edges', data=False)

G,n = read_graph(SYNTH_GRAP_PATH+f'Gnp/G-{n}-deg-{d}.edges')

Tau = init_Tau(G,n)

file = SYNTH_GRAP_PATH+f'Gnp/G-{n}-deg-{d}.thresholds'

with open(file,'w') as f:
    for i in range(0,n):
        print(i+1,Tau[i],file=f)
f.close()
print(' time:',time.time()-start)