## Dependencies
- PyTorch
- transformers
- diffusers
- datasets

## Detect memorization
1. Download memorized prompts: https://huggingface.co/datasets/fraisdufour/templates-verbs/resolve/main/groundtruth_parquets/sdv1_bb_edge_groundtruth.parquet

2. Download memorized images:
```
python download_memorized_images.py
```

3. Run detection:
on memorized prompts
```
python detect_mem.py --run_name memorization --end 500 --dataset sdv1_500_men_groundtruth --gen_seed 0
```

on non-memorized prompts like coco
```
python detect_mem.py --run_name coco --dataset coco --data_dir <data_dir_for_coco> --end 500 --dataset sdv1_500_men_groundtruth --gen_seed 0
```

4. check results: you may check detection results with `det_mem_viz.ipynb`.

You may also check `mem_mag_viz.ipynb` for some visualizations

## Explain memorization
Please check out `token_wise_significance.ipynb`

## Mitigate memorization
Please check out `mitigation.ipynb`
