import os
import sys
sys.path.append(os.getcwd())

import PIL.Image as Image
from data_generation.constants import *

relations_to_test = [ABOVE, BEHIND]


cosine_multi_save_path = ""
for relation in relations_to_test:
    relation_path = os.path.join(cosine_multi_save_path, relation, "default")
    for i in range(37):
        im_dir = os.path.join(relation_path, f"{i}")
        front_view_im_path = os.path.join(im_dir, "front_view.png")
        side_view_im_path = os.path.join(im_dir, "side_view.png")
        # load image and concatenate them
        front_view_im = Image.open(front_view_im_path)
        side_view_im = Image.open(side_view_im_path)
        im_width = front_view_im.width + side_view_im.width
        im_height = front_view_im.height
        im = Image.new("RGB", (im_width, im_height))
        im.paste(front_view_im, (0, 0))
        im.paste(side_view_im, (front_view_im.width, 0))
        im.save(os.path.join(im_dir, "concatenated.png"))