import math
from data_generation.constants import *

# None to be overwritten as per variation
DEFAULT_CONFIG = {
    "variation": "default",
    "num_steps": 37,
    "save_path": None,
    "ref_shape": CUBE,
    "ref_color": BLUE,
    "ref_size": 0.7,
    "ref_position": (0, 0, 0.7),
    "ref_rotation": None,
    "var_shape": SPHERE,
    "var_color": RED,
    "var_size": 0.7,
    "var_position": (0, 0, 0.7),
    "num_distractors": 0,
}

# Positional attributes
RELATIONS = {
    # Translation relations
    ABOVE: {
        "relation": ABOVE,
        "path_type": "translate",
        "ref_position": (0, 0, 0.7),
        "start_point": (-2.5, -2.5, 2.8),
        "end_point": (2.5, 2.5, 2.8),
    },
    UNDER: {
        "relation": UNDER,
        "path_type": "translate",
        "ref_position": (0, 0, 0.7 + 2.3),
        "start_point": (-2.5, -2.5, 0.7),
        "end_point": (2.5, 2.5, 0.7),
    },
    IN_BETWEEN: {
        "relation": IN_BETWEEN,
        "path_type": "translate",
        "ref_position": [(-2.5, -2.5, 0.7), (2.5, 2.5, 0.7)],
        "ref_rotation": [(0, 0, math.radians(45)), (0, 0, math.radians(45))],
        "start_point": (-3.85, 3.85, 0.7),
        "end_point": (3.85, -3.85, 0.7),
    },
    IN: {
        "relation": IN,
        "path_type": "translate",
        "ref_shape": BOX,
        "ref_position": (0, 0, 0.7),
        "var_size": 0.69,
        "start_point": (0, 0, 0.7),
        "end_point": (0, 0, 3.3),
    },
    MIDDLE: {
        "relation": MIDDLE,
        "path_type": "translate",
        "ref_shape": FAT_CYLINDER,
        "ref_size": 2.5,
        "ref_position": (0, 0, 0.2),
        "start_point": (-2.5, -2.5, 1.0),
        "end_point": (2.5, 2.5, 1.0),
    },
    # Rotation relations
    BEHIND: {
        "relation": BEHIND,
        "path_type": "rotate",
        "radius": 3.5,
        "angle_range": (135, 135 + 360),
    },
    FRONT: {
        "relation": FRONT,
        "path_type": "rotate",
        "radius": 3.5,
        "angle_range": (135 + 180, 135 + 180 + 360),
    },
    LEFT: {
        "relation": LEFT,
        "path_type": "rotate",
        "radius": 3.5,
        "angle_range": (135 + 90, 135 + 90 + 360),
    },
    RIGHT: {
        "relation": RIGHT,
        "path_type": "rotate",
        "radius": 3.5,
        "angle_range": (135 - 90, 135 - 90 + 360),
    },
}

# Qualitative attributes
VARIATIONS = [
    {"variation": "default"},
    {"variation": "color", "var_color": YELLOW, "ref_color": GREEN},
    {"variation": "size", "var_size": 1.0, "ref_size": 0.5},
    {"variation": "shape", "var_shape": CUBE, "ref_shape": CYLINDER},
    {"variation": "sphere", "var_shape": SPHERE, "ref_shape": SPHERE},
]
