
import os
import sys
sys.path.append(os.getcwd())
sys.path.append('/home/name/mambaforge/lib/python3.10/site-packages')
sys.path.append('/home/name/spatial/LLaVA_interp/data_generation')

import time
import copy
import json
import argparse

import math
import random
import numpy as np
# import PIL.Image as Image

import pprint as pp
import bpy, bpy_extras

from data_generation.simple_configs import *
from data_generation.hard_configs import *
from data_generation.multi_configs import *
from data_generation.constants import *
from data_generation.custom_variations import custom_variations
from data_generation.utils import render_scene_config


if __name__ == "__main__":

    DEFAULT_CONFIG = HARD_DEFAULT_CONFIG
    VARIATIONS = HARD_VARIATIONS
    RELATIONS = HARD_RELATIONS

    
    
    relations_to_test = [BEHIND]
    VARIATIONS = [{"variation": "default"}]
    debug = False

    RENDER_SHADOW = True
    repeat = 1

    for i in range(repeat):
        DEFAULT_CONFIG['ref_rotation'] = (90, 0, 60*i)
        DEFAULT_CONFIG['var_rotation'] = (90, 0, 60*i)
        OUTPUT_DIR = f"/home/name/spatial/LLaVA_interp/data_generation/output/sample_model/0610/{i}"
        DEFAULT_CONFIG['save_path'] = OUTPUT_DIR
        for relation, relation_config in RELATIONS.items():
            distractors = []
            for variation in VARIATIONS:
                if relation not in relations_to_test:
                    continue
                relation_config_copy = copy.deepcopy(relation_config)
                relation_config_copy = custom_variations(relation, variation, DEFAULT_CONFIG, relation_config_copy, cosine_simple=False, cosine_multi=False)
                config = {**DEFAULT_CONFIG, **variation, **relation_config_copy}

                if debug:
                    pp.pprint(relation, stream=sys.stderr)
                    pp.pprint(variation, stream=sys.stderr)
                    pp.pprint(config, stream=sys.stderr, sort_dicts=False)
                
                # render the scene based on config
                print(f"Variation: {variation['variation']} | Relation: {relation}", file=sys.stderr)
                mapping, distractors = render_scene_config(**config, distractors=distractors, cosine_simple=False, cosine_multi=False, render_shadow=RENDER_SHADOW)
                # save the config per variation
                if DEFAULT_CONFIG['num_distractors'] > 0: 
                    variation_name = f"{variation['variation']}_{DEFAULT_CONFIG['num_distractors']}_distractors"
                else:
                    variation_name = variation['variation']
                output_path = os.path.join("/home/name/spatial/LLaVA_interp/data_generation/output/cosine_multi_0601", relation, variation_name, distractors)
                os.makedirs(output_path, exist_ok=True)
                config_path = os.path.join(output_path, "config.json")
                with open(config_path, "w") as f:
                    config_copy = copy.deepcopy(config)
                    config_copy['var_color'] = color_to_name(config['var_color'])
                    config_copy['ref_color'] = color_to_name(config['ref_color'])
                    config_copy['mapping'] = mapping
                    if distractors is not None and not isinstance(distractors, str):
                        for distractor in distractors:
                            distractor['location'] = np.array(distractor['location']).tolist()
                            distractor['dimensions'] = np.array(distractor['dimensions']).tolist()
                            distractor['color'] = color_to_name(distractor['color'])
                            distractor['position'] = np.array(distractor['position']).tolist()
                    # print(distractors, file=sys.stderr)
                    config_copy['distractor'] = distractors
                    assert(len(mapping) == DEFAULT_CONFIG["num_steps"])
                    json.dump(config_copy, f, indent=4)