import bpy

def load_blend_file(filepath):
    # Ensure that no other data is present
    bpy.ops.wm.read_factory_settings(use_empty=True)

    # Load the base scene .blend file
    bpy.ops.wm.open_mainfile(filepath=filepath)

def import_model(filepath):
    # Import the .blend model into the current scene
    with bpy.data.libraries.load(filepath, link=False) as (data_from, data_to):
        data_to.objects = data_from.objects

    # Link objects to the scene
    for obj in data_to.objects:
        if obj is not None:
            bpy.context.collection.objects.link(obj)

def set_active_camera():
    # Check if there is a camera in the scene
    cameras = [obj for obj in bpy.data.objects if obj.type == 'CAMERA']
    print(cameras)
    if cameras:
        bpy.context.scene.camera = cameras[0]

def render_scene(output_path, resolution_x=1920, resolution_y=1080, resolution_percentage=100):
    # Set rendering settings
    bpy.context.scene.render.resolution_x = resolution_x
    bpy.context.scene.render.resolution_y = resolution_y
    bpy.context.scene.render.resolution_percentage = resolution_percentage
    bpy.context.scene.render.filepath = output_path
    bpy.ops.render.render(write_still=True)

if __name__ == "__main__":
    base_scene_path = "/home/name/spatial/LLaVA_interp/clevr/image_generation/data/base_scene_centered.blend"
    model_file_path = "/home/name/spatial/LLaVA_interp/clevr/image_generation/data/shapes/Sophia.blend"
    output_image_path = "/home/name/spatial/LLaVA_interp/image.png"

    load_blend_file(base_scene_path)
    import_model(model_file_path)
    set_active_camera()
    render_scene(output_image_path)